/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.validation;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.cli2.resource.ResourceHelper;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;

public class UrlValidator
implements Validator {
    private String protocol = null;

    public UrlValidator() {
    }

    public UrlValidator(String protocol) {
        this.setProtocol(protocol);
    }

    public void validate(List values) throws InvalidArgumentException {
        ListIterator<URL> i = values.listIterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            try {
                URL url = new URL(name);
                if (this.protocol != null && !this.protocol.equals(url.getProtocol())) {
                    throw new InvalidArgumentException(name);
                }
                i.set(url);
            }
            catch (MalformedURLException mue) {
                throw new InvalidArgumentException(ResourceHelper.getResourceHelper().getMessage("URLValidator.malformed.URL", new Object[]{name}));
            }
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

