/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal;

import com.jayway.jsonpath.InvalidModelException;
import com.jayway.jsonpath.internal.filter.FilterFactory;
import com.jayway.jsonpath.internal.filter.PathTokenFilter;
import com.jayway.jsonpath.spi.JsonProvider;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathToken {
    private static final Pattern ARRAY_INDEX_PATTERN = Pattern.compile("\\[(\\d+)\\]");
    private String fragment;

    public PathToken(String fragment) {
        this.fragment = fragment;
    }

    public PathTokenFilter getFilter() {
        return FilterFactory.createFilter(this.fragment);
    }

    public Object filter(Object model, JsonProvider jsonProvider) {
        return FilterFactory.createFilter(this.fragment).filter(model, jsonProvider);
    }

    public Object apply(Object model, JsonProvider jsonProvider) {
        return FilterFactory.createFilter(this.fragment).getRef(model, jsonProvider);
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean isRootToken() {
        return "$".equals(this.fragment);
    }

    public boolean isArrayIndexToken() {
        return ARRAY_INDEX_PATTERN.matcher(this.fragment).matches();
    }

    public int getArrayIndex() {
        Matcher matcher = ARRAY_INDEX_PATTERN.matcher(this.fragment);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        throw new InvalidModelException("Could not get array index from fragment " + this.fragment);
    }
}

