/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.AbstractStringView;
import com.xebialabs.deployit.core.ListOfStringView;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.SetOfStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderReplacer;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import com.xebialabs.deployit.service.replacement.PlaceholderExpander;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConsolidatedDictionary {
    private MapStringStringView entries = new MapStringStringView();
    private MustachePlaceholderScanner scanner = new MustachePlaceholderScanner();

    public static ConsolidatedDictionary create(Collection<Dictionary> dicts) {
        ConsolidatedDictionary dictionary = new ConsolidatedDictionary();
        Checks.checkNotNull(dicts, "Should not have null dictionaries");
        for (Dictionary dict : dicts) {
            dictionary.addDictionary(dict);
        }
        dictionary.entries = PlaceholderExpander.expand(dictionary.entries);
        return dictionary;
    }

    private void addDictionary(Dictionary d) {
        MapStringStringView dictEntries = MapStringStringView.copy(d.getEntries());
        dictEntries.putAll(MapStringStringView.from(d.getEncryptedEntries()));
        for (String key : dictEntries.keySet()) {
            if (this.entries.containsKey(key)) continue;
            this.entries.put(key, dictEntries.getWrappedValue(key));
        }
    }

    public Map<String, String> getEntries() {
        return this.entries;
    }

    public boolean containsKey(String key) {
        return this.entries.containsKey(key);
    }

    public String get(String key) {
        return this.entries.get(key);
    }

    public StringValue resolveScannedPlaceholder(String filePlaceholder) {
        return this.entries.getWrappedValue(filePlaceholder);
    }

    public void resolveDeployedName(EmbeddedDeployedContainer<?, ?> deployed) throws DictionaryValueException {
        String name = deployed.getName();
        if (MustachePlaceholderScanner.hasPlaceholders(name)) {
            MustachePlaceholderReplacer placeholderReplacer = new MustachePlaceholderReplacer(this.entries.getWrapped(), false);
            StringValue sv = placeholderReplacer.replace(name);
            String newName = sv.toPublicFacingValue();
            this.checkNewNameValid(deployed.getId(), newName);
            deployed.setId(IdGenerator.generateId((ConfigurationItem)deployed.getContainer(), (String)newName));
        }
    }

    private void checkNewNameValid(String id, String newName) throws DictionaryValueException {
        if (newName.contains("/")) {
            throw new DictionaryValueException("Replaced name [%s] contains extra slashes, was: [%s]", newName, id);
        }
        if (newName.isEmpty()) {
            throw new DictionaryValueException("Replaced name for [%s] resolved to empty value.", id);
        }
    }

    public Object resolve(Object value, PropertyDescriptor deployablePropDesc) throws DictionaryValueException {
        if (value == null) {
            return null;
        }
        MustachePlaceholderReplacer placeholderReplacer = new MustachePlaceholderReplacer(this.entries.getWrapped(), false);
        switch (deployablePropDesc.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case LIST_OF_CI: 
            case CI: 
            case DATE: 
            case SET_OF_CI: 
            case ENUM: {
                return value;
            }
            case STRING: {
                return placeholderReplacer.replace((String)value);
            }
            case SET_OF_STRING: {
                return this.resolveCollection((Set)value, new SetOfStringView(), placeholderReplacer);
            }
            case LIST_OF_STRING: {
                return this.resolveCollection((List)value, new ListOfStringView(), placeholderReplacer);
            }
            case MAP_STRING_STRING: {
                return this.resolveMap((Map)value, placeholderReplacer);
            }
        }
        throw new IllegalStateException("Unknown property kind: " + deployablePropDesc.getKind());
    }

    private Object resolveMap(Map<String, String> value, MustachePlaceholderReplacer placeholderReplacer) {
        MapStringStringView resolvedMap = new MapStringStringView();
        for (Map.Entry<String, String> entry : value.entrySet()) {
            try {
                resolvedMap.put(entry.getKey(), placeholderReplacer.replace(entry.getValue()));
            }
            catch (DictionaryValueException e) {
                resolvedMap.put(entry.getKey(), entry.getValue());
            }
        }
        return resolvedMap;
    }

    private Collection<String> resolveCollection(Collection<String> value, AbstractStringView<?> resolved, MustachePlaceholderReplacer placeholderReplacer) {
        for (String s : value) {
            try {
                resolved.add(placeholderReplacer.replace(s));
            }
            catch (DictionaryValueException e) {
                resolved.add(s);
            }
        }
        return resolved;
    }
}

