/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.xebialabs.deployit.core.EncryptedStringValue;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholders;
import com.xebialabs.deployit.service.replacement.ReaderChunker;
import java.io.Reader;
import java.io.Writer;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MustachePlaceholderReplacer {
    public static final String IGNORE_PLACEHOLDER = "<ignore>";
    public static final String EMPTY_PLACEHOLDER = "<empty>";
    private final ReplacerMap values;
    private EnumSet<Mode> modes = EnumSet.noneOf(Mode.class);

    public MustachePlaceholderReplacer(Map<String, ?> values) {
        this(values, true);
    }

    public MustachePlaceholderReplacer(Map<String, ?> values, boolean interpretSpecialValues) {
        if (interpretSpecialValues) {
            this.modes.add(Mode.SPECIAL_VALUES);
        }
        this.modes.add(Mode.MISSING_VALUES);
        this.values = new ReplacerMap(values, this.modes);
    }

    public StringValue replace(StringValue replaceable) throws DictionaryValueException {
        EncryptionDetectionMap encryptionDetector = new EncryptionDetectionMap(this.values);
        String execute = MustachePlaceholders.newMustacheCompiler().compile(replaceable.toString()).execute((Object)encryptionDetector);
        this.checkMissingValuesAndThrowException(replaceable);
        return this.buildStringValue(replaceable, encryptionDetector, execute);
    }

    private StringValue buildStringValue(StringValue replaceable, EncryptionDetectionMap encryptionDetector, String execute) {
        if (encryptionDetector.wasEncrypted || replaceable instanceof EncryptedStringValue) {
            return new EncryptedStringValue(execute);
        }
        return new StringValue(execute);
    }

    private void checkMissingValuesAndThrowException(StringValue replaceable) throws DictionaryValueException {
        Set<String> missingValues = this.values.getMissingValues();
        if (!missingValues.isEmpty()) {
            Set<String> missingKeys = new HashSet<String>(missingValues).stream().filter(x -> this.isADictionaryPlaceholder((String)x)).collect(Collectors.toSet());
            missingValues.clear();
            throw new DictionaryValueException((Throwable)new IllegalArgumentException("Placeholders values could not be replaced"), missingKeys, "Could not replace dictionary keys in %s", replaceable);
        }
    }

    private boolean isADictionaryPlaceholder(String placeholder) {
        return !placeholder.startsWith("%") && !placeholder.startsWith("'");
    }

    public StringValue replace(String replaceable) throws DictionaryValueException {
        return this.replace(new StringValue(replaceable));
    }

    public void replace(Reader in, Writer out, String delimiters) {
        Reader reader;
        ReaderChunker readerChunker = new ReaderChunker(in, delimiters);
        while ((reader = readerChunker.next()) != null) {
            MustachePlaceholders.newMustacheCompiler().withDelims(delimiters).compile(reader).execute((Object)this.values, out);
        }
    }

    private class ReplacerMap
    extends HashMap<String, Object> {
        private Set<String> missingValues;
        private EnumSet<Mode> modes;

        public ReplacerMap(Map<String, ?> map, EnumSet<Mode> modes) {
            super(map);
            this.missingValues = new HashSet<String>();
            this.modes = modes;
        }

        @Override
        public Object get(Object o) {
            Object s = super.get(o);
            if (this.modes.contains((Object)Mode.SPECIAL_VALUES)) {
                if (MustachePlaceholderReplacer.IGNORE_PLACEHOLDER.equals(s)) {
                    return "{{" + o + "}}";
                }
                if (MustachePlaceholderReplacer.EMPTY_PLACEHOLDER.equals(s)) {
                    return "";
                }
            }
            if (this.modes.contains((Object)Mode.MISSING_VALUES) && s == null) {
                String key = (String)o;
                this.missingValues.add(key);
                return key;
            }
            return s;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.modes.contains((Object)Mode.MISSING_VALUES) || super.containsKey(key);
        }

        public Set<String> getMissingValues() {
            return this.missingValues;
        }
    }

    private class EncryptionDetectionMap
    extends HashMap<String, Object> {
        boolean wasEncrypted = false;
        final ReplacerMap delegate;

        public EncryptionDetectionMap(ReplacerMap map) {
            this.delegate = map;
        }

        @Override
        public Object get(Object o) {
            Object get = this.delegate.get(o);
            if (get instanceof EncryptedStringValue) {
                this.wasEncrypted = true;
            }
            return get;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }
    }

    private static enum Mode {
        SPECIAL_VALUES,
        MISSING_VALUES;

    }
}

