/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.upgrade;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.booter.local.PluginVersions;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.RepositoryInitialization;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlplatform.upgrade.UpgraderHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RepositoryInitializer
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryInitializer.class);
    private ApplicationContext context;
    private JcrTemplate jcrTemplate;
    private RepositoryVersionService repositoryVersionService;

    public RepositoryInitializer(JcrTemplate jcrTemplate, RepositoryVersionService repositoryVersionService) {
        this.jcrTemplate = jcrTemplate;
        this.repositoryVersionService = repositoryVersionService;
    }

    public void initializeComponents() {
        ListMultimap<String, RepositoryInitialization> initializations = this.getInitializations();
        for (String component : this.getRegisteredPlugins()) {
            this.initializeComponent(component, initializations);
        }
    }

    private void initializeComponent(String component, ListMultimap<String, RepositoryInitialization> initializations) {
        Version componentVersion;
        try {
            componentVersion = this.repositoryVersionService.readVersionOfComponent(component);
        }
        catch (RuntimeException e) {
            logger.warn(String.format("Component [%s] has an invalid version", component), (Throwable)e);
            return;
        }
        if (componentVersion == null) {
            this.doInitializeComponent(component, initializations);
            this.repositoryVersionService.storeVersionOfComponent(Version.valueOf((String)component, (String)"0.0.0"));
        } else {
            logger.debug("Component {} is already initialized", (Object)component);
        }
    }

    private void doInitializeComponent(String component, ListMultimap<String, RepositoryInitialization> initializations) {
        List componentInitializations = initializations.get((Object)component);
        if (!componentInitializations.isEmpty()) {
            final ArrayList sortedInitializations = Lists.newArrayList((Iterable)componentInitializations);
            Collections.sort(sortedInitializations, new Comparator<RepositoryInitialization>(){

                @Override
                public int compare(RepositoryInitialization o1, RepositoryInitialization o2) {
                    return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
                }
            });
            logger.info("Initializing repository for component [{}] using: {}", (Object)component, (Object)sortedInitializations);
            this.jcrTemplate.execute((JcrCallback)new JcrCallback<Object>(){

                public Object doInJcr(Session session) throws RepositoryException {
                    for (RepositoryInitialization initialization : sortedInitializations) {
                        logger.debug("Running initialization [{}]: {}", initialization.getClass(), (Object)initialization);
                        initialization.doInitialize((RawRepository)new RawRepositoryImpl(session));
                    }
                    session.save();
                    return null;
                }
            });
        }
    }

    private ListMultimap<String, RepositoryInitialization> getInitializations() {
        Collection<RepositoryInitialization> allInitializations = this.findAndInstantiateSubTypesOf();
        logger.debug("Found the following initializations: [{}]", allInitializations);
        return Multimaps.index(allInitializations, (Function)new Function<RepositoryInitialization, String>(){

            public String apply(RepositoryInitialization input) {
                return input.getComponent();
            }
        });
    }

    @VisibleForTesting
    Collection<RepositoryInitialization> findAndInstantiateSubTypesOf() {
        return UpgraderHelper.findAndInstantiateSubTypesOf(RepositoryInitialization.class, this.context);
    }

    @VisibleForTesting
    Set<String> getRegisteredPlugins() {
        return PluginVersions.getRegisteredPlugins();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

