/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.Reflection;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.ExtensionLogger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.federation.FederationManager;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.cache.AllPathsCache;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.WorkspaceNotFoundException;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.LocalDocumentStore;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.federation.ConnectorChangeSetImpl;
import org.modeshape.jcr.spi.federation.Connector;
import org.modeshape.jcr.spi.federation.ConnectorChangeSet;
import org.modeshape.jcr.spi.federation.ConnectorChangeSetFactory;
import org.modeshape.jcr.spi.federation.ExtraPropertiesStore;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.WorkspaceAndPath;

@ThreadSafe
public final class Connectors {
    protected static final Logger LOGGER = Logger.getLogger(Connectors.class);
    private final JcrRepository.RunningState repository;
    private final Logger logger;
    private boolean initialized = false;
    private final AtomicReference<Snapshot> snapshot = new AtomicReference();
    private volatile DocumentTranslator translator;

    protected Connectors(JcrRepository.RunningState repository, Collection<RepositoryConfiguration.Component> components, Set<String> externalSources, Map<String, List<RepositoryConfiguration.ProjectionConfiguration>> preconfiguredProjections) {
        this.repository = repository;
        this.logger = Logger.getLogger(this.getClass());
        this.snapshot.set(new Snapshot(components, externalSources, preconfiguredProjections));
    }

    protected synchronized void initialize() throws RepositoryException {
        if (this.initialized || !this.hasConnectors()) {
            return;
        }
        this.initializeConnectors();
        this.createExternalWorkspaces();
        this.loadStoredProjections(false);
        this.createPreconfiguredProjections();
        this.loadStoredProjections(true);
        this.initialized = true;
    }

    private void createExternalWorkspaces() {
        Snapshot current = this.snapshot.get();
        Set<String> workspaces = current.externalSources();
        for (String workspaceName : workspaces) {
            this.repository.repositoryCache().createExternalWorkspace(workspaceName, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPreconfiguredProjections() throws RepositoryException {
        assert (!this.initialized);
        Snapshot current = this.snapshot.get();
        for (String workspaceName : current.getWorkspacesWithProjections()) {
            JcrSession session = this.repository.loginInternalSession(workspaceName);
            try {
                FederationManager federationManager = session.getWorkspace().getFederationManager();
                List<RepositoryConfiguration.ProjectionConfiguration> projections = current.getProjectionConfigurationsForWorkspace(workspaceName);
                for (RepositoryConfiguration.ProjectionConfiguration projectionCfg : projections) {
                    AbstractJcrNode node;
                    if (current.isUnused(projectionCfg.getSourceName())) {
                        LOGGER.debug("Ignoring projection '{0}' because the connector for '{1}' is unused", new Object[]{projectionCfg, projectionCfg.getSourceName()});
                        continue;
                    }
                    String repositoryPath = projectionCfg.getRepositoryPath();
                    String alias = projectionCfg.getAlias();
                    if (current.hasInternalProjection(alias, (node = session.getNode(repositoryPath)).key().toString()) || this.projectedPathExists(session, projectionCfg)) continue;
                    federationManager.createProjection(repositoryPath, projectionCfg.getSourceName(), projectionCfg.getExternalPath(), alias);
                }
            }
            finally {
                session.logout();
            }
        }
    }

    private boolean projectedPathExists(JcrSession session, RepositoryConfiguration.ProjectionConfiguration projectionCfg) throws RepositoryException {
        try {
            session.getNode(projectionCfg.getProjectedPath());
            this.repository.warn(JcrI18n.projectedPathPointsTowardsInternalNode, projectionCfg, projectionCfg.getSourceName(), projectionCfg.getProjectedPath());
            return true;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    private void loadStoredProjections(boolean validate) {
        assert (!this.initialized);
        SessionCache systemSession = this.repository.createSystemSession(this.repository.context(), false);
        CachedNode systemNode = this.getSystemNode(systemSession);
        ChildReference federationNodeRef = systemNode.getChildReferences(systemSession).getChild(ModeShapeLexicon.FEDERATION);
        if (federationNodeRef != null) {
            Collection<Projection> newProjections = this.loadStoredProjections(systemSession, federationNodeRef, validate);
            Snapshot current = this.snapshot.get();
            Snapshot updated = current.withProjections(newProjections);
            this.snapshot.compareAndSet(current, updated);
        }
    }

    private Collection<Projection> loadStoredProjections(SessionCache systemSession, ChildReference federationNodeRef, boolean validate) {
        MutableCachedNode federationNode = systemSession.mutable(federationNodeRef.getKey());
        ChildReferences federationChildRefs = federationNode.getChildReferences(systemSession);
        ArrayList<Projection> result = new ArrayList<Projection>();
        ArrayList<Projection> invalidProjections = new ArrayList<Projection>();
        Map<String, String> workspaceNameByKey = this.workspaceNamesByKey();
        Iterator<ChildReference> iter = federationChildRefs.iterator(ModeShapeLexicon.PROJECTION);
        while (iter.hasNext()) {
            ChildReference projectionRef = iter.next();
            NodeKey projectionRefKey = projectionRef.getKey();
            CachedNode projectionNode = systemSession.getNode(projectionRefKey);
            String externalNodeKeyString = projectionNode.getProperty(ModeShapeLexicon.EXTERNAL_NODE_KEY, systemSession).getFirstValue().toString();
            assert (externalNodeKeyString != null);
            String projectedNodeKeyString = projectionNode.getProperty(ModeShapeLexicon.PROJECTED_NODE_KEY, systemSession).getFirstValue().toString();
            assert (projectedNodeKeyString != null);
            String alias = projectionNode.getProperty(ModeShapeLexicon.PROJECTION_ALIAS, systemSession).getFirstValue().toString();
            assert (alias != null);
            Projection projection = new Projection(externalNodeKeyString, projectedNodeKeyString, alias);
            if (!validate || this.repository.documentStore().containsKey(externalNodeKeyString)) {
                result.add(projection);
                continue;
            }
            invalidProjections.add(projection);
            federationNode.removeChild(systemSession, projectionRefKey);
            systemSession.destroy(projectionRefKey);
            NodeKey projectedNodeKey = new NodeKey(projectedNodeKeyString);
            String wsName = workspaceNameByKey.get(projectedNodeKey.getWorkspaceKey());
            if (StringUtil.isBlank((String)wsName)) continue;
            SessionCache sessionCache = this.repository.repositoryCache().createSession(this.repository.context(), wsName, false);
            MutableCachedNode parentNode = sessionCache.mutable(projectedNodeKey);
            parentNode.removeFederatedSegment(externalNodeKeyString);
            sessionCache.save();
        }
        if (!invalidProjections.isEmpty()) {
            Snapshot current = this.snapshot.get();
            Snapshot updated = current.withoutProjections(invalidProjections.toArray(new Projection[invalidProjections.size()]));
            this.snapshot.compareAndSet(current, updated);
        }
        return result;
    }

    private CachedNode getSystemNode(SessionCache systemSession) {
        CachedNode systemRoot = systemSession.getNode(systemSession.getRootKey());
        ChildReference systemNodeRef = systemRoot.getChildReferences(systemSession).getChild(JcrLexicon.SYSTEM);
        assert (systemNodeRef != null);
        return systemSession.getNode(systemNodeRef.getKey());
    }

    private void initializeConnectors() {
        assert (!this.initialized);
        Session session = null;
        try {
            session = this.repository.loginInternalSession();
            NamespaceRegistry registry = session.getWorkspace().getNamespaceRegistry();
            javax.jcr.nodetype.NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
            if (!(nodeTypeManager instanceof NodeTypeManager)) {
                throw new IllegalStateException("Invalid node type manager (expected modeshape NodeTypeManager): " + nodeTypeManager.getClass().getName());
            }
            Snapshot current = this.snapshot.get();
            ArrayList<Connector> connectorsWithErrors = new ArrayList<Connector>();
            for (Connector connector : current.getConnectors()) {
                try {
                    this.initializeConnector(connector, registry, (NodeTypeManager)nodeTypeManager);
                }
                catch (Throwable t) {
                    this.repository.error(t, JcrI18n.unableToInitializeConnector, connector, this.repository.name(), t.getMessage());
                    connectorsWithErrors.add(connector);
                }
            }
            if (!connectorsWithErrors.isEmpty()) {
                Snapshot updated = current.withoutConnectors(connectorsWithErrors);
                this.snapshot.compareAndSet(current, updated);
            }
        }
        catch (RepositoryException e) {
            throw new SystemFailureException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private void storeProjection(Projection projection) {
        NodeKey systemNodeKey;
        PropertyFactory propertyFactory = this.repository.context().getPropertyFactory();
        SessionCache systemSession = this.repository.createSystemSession(this.repository.context(), false);
        MutableCachedNode systemNode = systemSession.mutable(systemNodeKey = this.getSystemNode(systemSession).getKey());
        ChildReference federationNodeRef = systemNode.getChildReferences(systemSession).getChild(ModeShapeLexicon.FEDERATION);
        if (federationNodeRef == null) {
            try {
                Property primaryType = propertyFactory.create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.FEDERATION);
                systemNode.createChild(systemSession, systemNodeKey.withId("mode:federation"), ModeShapeLexicon.FEDERATION, primaryType, new Property[0]);
                systemSession.save();
                federationNodeRef = systemNode.getChildReferences(systemSession).getChild(ModeShapeLexicon.FEDERATION);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        NodeKey federationNodeKey = federationNodeRef.getKey();
        MutableCachedNode federationNode = systemSession.mutable(federationNodeKey);
        Property primaryType = propertyFactory.create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.PROJECTION);
        Property externalNodeKeyProp = propertyFactory.create(ModeShapeLexicon.EXTERNAL_NODE_KEY, projection.getExternalNodeKey());
        Property projectedNodeKeyProp = propertyFactory.create(ModeShapeLexicon.PROJECTED_NODE_KEY, projection.getProjectedNodeKey());
        Property alias = propertyFactory.create(ModeShapeLexicon.PROJECTION_ALIAS, projection.getAlias());
        federationNode.createChild(systemSession, federationNodeKey.withRandomId(), ModeShapeLexicon.PROJECTION, primaryType, externalNodeKeyProp, projectedNodeKeyProp, alias);
        systemSession.save();
    }

    public String getProjectedNodeKey(String externalNodeKey) {
        Projection projection = this.snapshot.get().getProjectionForExternalNode(externalNodeKey);
        return projection != null ? projection.getProjectedNodeKey() : null;
    }

    public synchronized void addProjection(String externalNodeKey, String projectedNodeKey, String alias) {
        Projection projection = new Projection(externalNodeKey, projectedNodeKey, alias);
        this.storeProjection(projection);
        Snapshot current = this.snapshot.get();
        Snapshot updated = current.withProjection(projection);
        this.snapshot.compareAndSet(current, updated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void externalNodeRemoved(String externalNodeKey) {
        if (this.snapshot.get().containsProjectionForExternalNode(externalNodeKey)) {
            Connectors connectors = this;
            synchronized (connectors) {
                Snapshot current = this.snapshot.get();
                Snapshot updated = current.withoutProjection(externalNodeKey);
                if (current != updated) {
                    this.snapshot.compareAndSet(current, updated);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalNodeRemoved(String internalNodeKey) {
        if (this.snapshot.get().containsProjectionForInternalNode(internalNodeKey)) {
            Connectors connectors = this;
            synchronized (connectors) {
                Snapshot current;
                Snapshot updated = current = this.snapshot.get();
                for (Projection projection : current.getProjections()) {
                    if (!internalNodeKey.equalsIgnoreCase(projection.getProjectedNodeKey())) continue;
                    String externalNodeKey = projection.getExternalNodeKey();
                    this.removeStoredProjection(externalNodeKey);
                    updated = updated.withoutProjection(externalNodeKey);
                }
                if (current != updated) {
                    this.snapshot.compareAndSet(current, updated);
                }
            }
        }
    }

    private void removeStoredProjection(String externalNodeKey) {
        SessionCache systemSession = this.repository.createSystemSession(this.repository.context(), false);
        NodeKey systemNodeKey = this.getSystemNode(systemSession).getKey();
        MutableCachedNode systemNode = systemSession.mutable(systemNodeKey);
        ChildReference federationNodeRef = systemNode.getChildReferences(systemSession).getChild(ModeShapeLexicon.FEDERATION);
        assert (federationNodeRef != null);
        NodeKey federationNodeKey = federationNodeRef.getKey();
        MutableCachedNode federationNode = systemSession.mutable(federationNodeKey);
        ChildReferences federationChildRefs = federationNode.getChildReferences(systemSession);
        int projectionsCount = federationChildRefs.getChildCount(ModeShapeLexicon.PROJECTION);
        for (int i = 1; i <= projectionsCount; ++i) {
            ChildReference projectionRef = federationChildRefs.getChild(ModeShapeLexicon.PROJECTION, i);
            NodeKey projectionRefKey = projectionRef.getKey();
            CachedNode storedProjection = systemSession.getNode(projectionRefKey);
            String storedProjectionExternalNodeKey = storedProjection.getProperty(ModeShapeLexicon.EXTERNAL_NODE_KEY, systemSession).getFirstValue().toString();
            assert (storedProjectionExternalNodeKey != null);
            if (!storedProjectionExternalNodeKey.equals(externalNodeKey)) continue;
            federationNode.removeChild(systemSession, projectionRefKey);
            systemSession.destroy(projectionRefKey);
            systemSession.save();
            break;
        }
    }

    protected Connector instantiateConnector(RepositoryConfiguration.Component component) {
        try {
            Connector connector = (Connector)component.createInstance(this.getClass().getClassLoader());
            Reflection.setValue((Object)connector, (String)"repositoryName", (Object)this.repository.name());
            Reflection.setValue((Object)connector, (String)"logger", (Object)Logger.getLogger(connector.getClass()));
            Reflection.setValue((Object)connector, (String)"simpleLogger", (Object)ExtensionLogger.getLogger(connector.getClass()));
            return connector;
        }
        catch (Throwable t) {
            if (t.getCause() != null) {
                t = t.getCause();
            }
            this.logger.error(t, (I18nResource)JcrI18n.unableToInitializeConnector, new Object[]{component, this.repository.name(), t.getMessage()});
            return null;
        }
    }

    protected void initializeConnector(Connector connector, NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws IOException, RepositoryException {
        Reflection.setValue((Object)connector, (String)"context", (Object)this.repository.context());
        Reflection.setValue((Object)connector, (String)"translator", (Object)this.getDocumentTranslator());
        Reflection.setValue((Object)connector, (String)"mimeTypeDetector", (Object)this.repository.mimeTypeDetector());
        Reflection.setValue((Object)connector, (String)"transactionManager", (Object)this.repository.txnManager());
        Reflection.setValue((Object)connector, (String)"connectorChangedSetFactory", (Object)this.createConnectorChangedSetFactory(connector));
        Reflection.setValue((Object)connector, (String)"environment", (Object)this.repository.environment());
        LocalDocumentStore store = this.repository.documentStore().localStore();
        String name = connector.getSourceName();
        String sourceKey = NodeKey.keyForSourceName(name);
        DocumentTranslator translator = this.getDocumentTranslator();
        LocalDocumentStoreExtraProperties defaultExtraPropertiesStore = new LocalDocumentStoreExtraProperties(store, sourceKey, translator);
        Reflection.setValue((Object)connector, (String)"extraPropertiesStore", (Object)defaultExtraPropertiesStore);
        connector.initialize(registry, nodeTypeManager);
        Method postInitialize = Reflection.findMethod(Connector.class, (String)"postInitialize");
        Reflection.invokeAccessibly((Object)connector, (Method)postInitialize, (Object[])new Object[0]);
    }

    protected JcrRepository.RunningState repository() {
        return this.repository;
    }

    private ConnectorChangeSetFactory createConnectorChangedSetFactory(final Connector c) {
        return new ConnectorChangeSetFactory(){

            @Override
            public ConnectorChangeSet newChangeSet() {
                PathMappings mappings = Connectors.this.getPathMappings(c);
                JcrRepository.RunningState repository = Connectors.this.repository();
                ExecutionContext context = repository.context();
                return new ConnectorChangeSetImpl(Connectors.this, mappings, context.getId(), context.getProcessId(), repository.repositoryKey(), repository.changeBus(), context.getValueFactories().getDateFactory(), Connectors.this.repository().journalId());
            }
        };
    }

    protected final Set<String> getWorkspacesWithProjectionsFor(Connector connector) {
        return this.snapshot.get().getWorkspacesWithProjectionsFor(connector);
    }

    protected final Map<String, String> workspaceNamesByKey() {
        HashMap<String, String> workspaceNamesByKey = new HashMap<String, String>();
        for (String workspaceName : this.repository.repositoryCache().getWorkspaceNames()) {
            workspaceNamesByKey.put(NodeKey.keyForWorkspaceName(workspaceName), workspaceName);
        }
        return workspaceNamesByKey;
    }

    protected synchronized void shutdown() {
        if (!this.initialized || !this.hasConnectors()) {
            return;
        }
        Snapshot current = this.snapshot.get();
        current.shutdownConnectors();
        current.shutdownUnusedConnectors();
        this.snapshot.set(current.withOnlyProjectionConfigurations());
    }

    protected boolean hasReadonlyConnectors() {
        return this.snapshot.get().hasReadonlyConnectors();
    }

    public Connector getConnectorForSourceKey(String sourceKey) {
        return this.snapshot.get().getConnectorWithSourceKey(sourceKey);
    }

    public String getSourceNameAtKey(String sourceKey) {
        return this.snapshot.get().getSourceNameAtKey(sourceKey);
    }

    public boolean hasExternalProjection(String alias, String externalNodeKey) {
        return this.snapshot.get().hasExternalProjection(alias, externalNodeKey);
    }

    public Connector getConnectorForSourceName(String sourceName) {
        assert (sourceName != null);
        return this.snapshot.get().getConnectorWithSourceKey(NodeKey.keyForSourceName(sourceName));
    }

    public boolean hasConnectors() {
        return this.snapshot.get().hasConnectors();
    }

    public DocumentTranslator getDocumentTranslator() {
        if (this.translator == null) {
            this.translator = this.repository.repositoryCache().getDocumentTranslator().withLargeStringSize(Long.MAX_VALUE);
        }
        return this.translator;
    }

    public PathMappings getPathMappings(Connector connector) {
        return this.snapshot.get().getPathMappings(connector);
    }

    protected boolean isReadonlyPath(Path path, JcrSession session) throws RepositoryException {
        AbstractJcrNode node = session.node(path);
        Connector connector = this.getConnectorForSourceKey(node.key().getSourceKey());
        return connector != null && connector.isReadonly();
    }

    protected static class LocalDocumentStoreExtraProperties
    implements ExtraPropertiesStore {
        private final LocalDocumentStore localStore;
        private final String sourceKey;
        private final DocumentTranslator translator;

        protected LocalDocumentStoreExtraProperties(LocalDocumentStore localStore, String sourceKey, DocumentTranslator translator) {
            this.localStore = localStore;
            this.sourceKey = sourceKey;
            this.translator = translator;
            assert (this.localStore != null);
            assert (this.sourceKey != null);
            assert (this.translator != null);
        }

        protected String keyFor(String id) {
            return this.sourceKey + ":" + id;
        }

        @Override
        public Map<Name, Property> getProperties(String id) {
            String key = this.keyFor(id);
            SchematicEntry entry = this.localStore.get(key);
            if (entry == null) {
                return NO_PROPERTIES;
            }
            Document doc = entry.getContent();
            HashMap<Name, Property> props = new HashMap<Name, Property>();
            this.translator.getProperties(doc, props);
            return props;
        }

        @Override
        public boolean removeProperties(String id) {
            String key = this.keyFor(id);
            return this.localStore.remove(key);
        }

        @Override
        public void storeProperties(String id, Map<Name, Property> properties) {
            String key = this.keyFor(id);
            EditableDocument doc = Schematic.newDocument();
            for (Map.Entry<Name, Property> entry : properties.entrySet()) {
                Property property = entry.getValue();
                if (property == null) continue;
                this.translator.setProperty(doc, property, null, null);
            }
            this.localStore.storeDocument(key, (Document)doc);
        }

        @Override
        public void updateProperties(String id, Map<Name, Property> properties) {
            String key = this.keyFor(id);
            EditableDocument doc = this.localStore.edit(key, true);
            assert (doc != null);
            for (Map.Entry<Name, Property> propertyEntry : properties.entrySet()) {
                Property property = propertyEntry.getValue();
                if (property != null) {
                    this.translator.setProperty(doc, property, null, null);
                    continue;
                }
                this.translator.removeProperty(doc, propertyEntry.getKey(), null, null);
            }
            this.localStore.storeDocument(key, (Document)doc);
        }

        @Override
        public boolean contains(String id) {
            String key = this.keyFor(id);
            SchematicEntry entry = this.localStore.get(key);
            return entry != null;
        }
    }

    @Immutable
    protected class Projection {
        private final String externalNodeKey;
        private final String projectedNodeKey;
        private final String alias;

        protected Projection(String externalNodeKey, String projectedNodeKey, String alias) {
            this.externalNodeKey = externalNodeKey;
            this.alias = alias;
            this.projectedNodeKey = projectedNodeKey;
        }

        protected boolean hasAlias(String alias) {
            return this.alias.equalsIgnoreCase(alias);
        }

        protected boolean hasProjectedNodeKey(String projectedNodeKey) {
            return this.projectedNodeKey.equals(projectedNodeKey);
        }

        protected boolean hasExternalNodeKey(String externalNodeKey) {
            return this.externalNodeKey.equals(externalNodeKey);
        }

        protected String getProjectedNodeKey() {
            return this.projectedNodeKey;
        }

        protected String getAlias() {
            return this.alias;
        }

        protected String getExternalNodeKey() {
            return this.externalNodeKey;
        }
    }

    protected static final class PathMapping {
        private final Path externalPath;
        private final WorkspaceAndPath internalPath;
        private final int hc;

        protected PathMapping(Path externalPath, Path internalPath, String workspaceName) {
            this.externalPath = externalPath;
            this.internalPath = new WorkspaceAndPath(workspaceName, internalPath);
            this.hc = HashCode.compute((Object[])new Object[]{this.externalPath, this.internalPath});
            assert (this.externalPath != null);
        }

        public WorkspaceAndPath resolveExternalPathToInternal(Path externalPath, PathFactory pathFactory) {
            if (this.externalPath.isRoot()) {
                return this.internalPath.withPath(pathFactory.create(this.internalPath.getPath(), externalPath));
            }
            if (this.externalPath.isAtOrAbove(externalPath)) {
                if (this.externalPath.size() == externalPath.size()) {
                    return this.internalPath;
                }
                Path subpath = externalPath.subpath(this.externalPath.size());
                return this.internalPath.withPath(pathFactory.create(this.internalPath.getPath(), subpath));
            }
            return null;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PathMapping) {
                PathMapping that = (PathMapping)obj;
                if (this.hc != that.hc) {
                    return false;
                }
                return this.externalPath.equals(that.externalPath) && this.internalPath.equals(that.internalPath);
            }
            return false;
        }

        public String toString() {
            return this.internalPath.toString() + " => " + this.externalPath.toString();
        }
    }

    protected static final class BasicPathMappings
    extends AbstractPathMappings {
        private Set<PathMapping> mappings = new HashSet<PathMapping>();
        private volatile boolean frozen;

        protected BasicPathMappings(String connectorSourceName, PathFactory pathFactory) {
            super(connectorSourceName, pathFactory);
        }

        @Override
        public Collection<WorkspaceAndPath> resolveExternalPathToInternal(Path externalPath) {
            assert (this.frozen);
            WorkspaceAndPath first = null;
            List<Object> results = null;
            for (PathMapping mapping : this.mappings) {
                WorkspaceAndPath resolved = mapping.resolveExternalPathToInternal(externalPath, this.pathFactory);
                if (resolved == null) continue;
                if (first == null) {
                    first = resolved;
                    continue;
                }
                if (results == null) {
                    results = new LinkedList<Object>();
                    results.add(first);
                }
                results.add(resolved);
            }
            return results != null ? results : (first != null ? Collections.singletonList(first) : EMPTY);
        }

        protected void add(Path externalPath, Path internalPath, String workspaceName) {
            this.mappings.add(new PathMapping(externalPath, internalPath, workspaceName));
        }

        protected void freeze() {
            if (this.mappings.size() == 0) {
                this.mappings = Collections.emptySet();
            }
            if (this.mappings.size() == 1) {
                this.mappings = Collections.singleton(this.mappings.iterator().next());
            }
            this.frozen = true;
        }

        public String toString() {
            return this.connectorSourceName + " mappings: " + this.mappings;
        }
    }

    @Immutable
    protected static final class EmptyPathMappings
    extends AbstractPathMappings {
        protected EmptyPathMappings(String connectorSourceName, PathFactory pathFactory) {
            super(connectorSourceName, pathFactory);
        }

        @Override
        public Collection<WorkspaceAndPath> resolveExternalPathToInternal(Path externalPath) {
            return EMPTY;
        }

        public String toString() {
            return "No mappings";
        }
    }

    @Immutable
    protected static abstract class AbstractPathMappings
    implements PathMappings {
        protected static final Collection<WorkspaceAndPath> EMPTY = Collections.emptyList();
        protected final String connectorSourceName;
        protected final PathFactory pathFactory;

        protected AbstractPathMappings(String connectorSourceName, PathFactory pathFactory) {
            this.connectorSourceName = connectorSourceName;
            this.pathFactory = pathFactory;
            assert (this.connectorSourceName != null);
            assert (this.pathFactory != null);
        }

        @Override
        public PathFactory getPathFactory() {
            return this.pathFactory;
        }

        @Override
        public String getConnectorSourceName() {
            return this.connectorSourceName;
        }
    }

    @Immutable
    public static interface PathMappings {
        public Collection<WorkspaceAndPath> resolveExternalPathToInternal(Path var1);

        public PathFactory getPathFactory();

        public String getConnectorSourceName();
    }

    @Immutable
    protected class Snapshot {
        private final Map<String, Connector> sourceKeyToConnectorMap;
        private final Map<String, List<RepositoryConfiguration.ProjectionConfiguration>> preconfiguredProjections;
        private final Map<String, Projection> projections;
        private final Set<String> projectedInternalNodeKeys;
        private final List<Connector> unusedConnectors = new LinkedList<Connector>();
        private volatile Map<String, BasicPathMappings> mappingsByConnectorSourceName;
        private boolean hasReadonlyConnectors;
        private final Set<String> externalSources;

        protected Snapshot(Collection<RepositoryConfiguration.Component> components, Set<String> externalSources, Map<String, List<RepositoryConfiguration.ProjectionConfiguration>> preconfiguredProjections) {
            this.externalSources = externalSources;
            this.preconfiguredProjections = preconfiguredProjections;
            this.projections = new HashMap<String, Projection>();
            this.sourceKeyToConnectorMap = new HashMap<String, Connector>();
            this.projectedInternalNodeKeys = new HashSet<String>();
            this.registerConnectors(components);
        }

        protected Snapshot(Snapshot original) {
            this.externalSources = original.externalSources;
            this.projections = new HashMap<String, Projection>(original.projections);
            this.sourceKeyToConnectorMap = new HashMap<String, Connector>(original.sourceKeyToConnectorMap);
            this.preconfiguredProjections = new HashMap<String, List<RepositoryConfiguration.ProjectionConfiguration>>(original.preconfiguredProjections);
            this.projectedInternalNodeKeys = new HashSet<String>(original.projectedInternalNodeKeys);
            this.hasReadonlyConnectors = original.hasReadonlyConnectors;
        }

        protected Set<String> externalSources() {
            return this.externalSources;
        }

        protected synchronized void shutdownUnusedConnectors() {
            for (Connector connector : this.unusedConnectors) {
                this.shutdownConnector(connector);
            }
            this.unusedConnectors.clear();
        }

        protected synchronized void shutdownConnectors() {
            for (Connector connector : this.sourceKeyToConnectorMap.values()) {
                this.shutdownConnector(connector);
            }
            this.sourceKeyToConnectorMap.clear();
        }

        private void shutdownConnector(Connector connector) {
            try {
                connector.shutdown();
            }
            catch (Throwable t) {
                LOGGER.debug(t, "Error while stopping connector for {0}", new Object[]{connector.getSourceName()});
            }
        }

        private void registerConnectors(Collection<RepositoryConfiguration.Component> components) {
            for (RepositoryConfiguration.Component component : components) {
                Connector connector = Connectors.this.instantiateConnector(component);
                if (connector == null) continue;
                this.registerConnector(connector);
            }
            this.checkForReadonlyConnectors();
        }

        private String keyFor(Connector connector) {
            return NodeKey.keyForSourceName(connector.getSourceName());
        }

        public boolean hasConnectors() {
            return !this.sourceKeyToConnectorMap.isEmpty();
        }

        public Connector getConnectorWithSourceKey(String sourceKey) {
            return this.sourceKeyToConnectorMap.get(sourceKey);
        }

        public String getSourceNameAtKey(String sourceKey) {
            Connector connector = this.sourceKeyToConnectorMap.get(sourceKey);
            return connector != null ? connector.getSourceName() : null;
        }

        public Collection<Connector> getConnectors() {
            return Collections.unmodifiableCollection(this.sourceKeyToConnectorMap.values());
        }

        public Collection<String> getWorkspacesWithProjections() {
            return Collections.unmodifiableCollection(this.preconfiguredProjections.keySet());
        }

        public List<RepositoryConfiguration.ProjectionConfiguration> getProjectionConfigurationsForWorkspace(String workspaceName) {
            return Collections.unmodifiableList(this.preconfiguredProjections.get(workspaceName));
        }

        public Set<String> getWorkspacesWithProjectionsFor(Connector connector) {
            String connectorSrcName = connector.getSourceName();
            HashSet<String> workspaceNames = new HashSet<String>();
            for (Map.Entry<String, List<RepositoryConfiguration.ProjectionConfiguration>> entry : this.preconfiguredProjections.entrySet()) {
                for (RepositoryConfiguration.ProjectionConfiguration config : entry.getValue()) {
                    if (!config.getSourceName().equals(connectorSrcName)) continue;
                    workspaceNames.add(entry.getKey());
                }
            }
            return workspaceNames;
        }

        public boolean hasInternalProjection(String alias, String projectedNodeKey) {
            for (Projection projection : this.projections.values()) {
                if (!projection.hasAlias(alias) || !projection.hasProjectedNodeKey(projectedNodeKey)) continue;
                return true;
            }
            return false;
        }

        public boolean hasExternalProjection(String alias, String externalNodeKey) {
            for (Projection projection : this.projections.values()) {
                if (!projection.hasAlias(alias) || !projection.hasExternalNodeKey(externalNodeKey)) continue;
                return true;
            }
            return false;
        }

        public Collection<Projection> getProjections() {
            return Collections.unmodifiableCollection(this.projections.values());
        }

        private void registerConnector(Connector connector) {
            String key = this.keyFor(connector);
            Connector existing = this.sourceKeyToConnectorMap.put(key, connector);
            if (existing != null) {
                this.unusedConnectors.add(existing);
            }
        }

        private boolean unregisterConnector(Connector connector) {
            String key = this.keyFor(connector);
            Connector existingConnector = this.sourceKeyToConnectorMap.get(key);
            if (existingConnector == connector) {
                this.sourceKeyToConnectorMap.remove(key);
                this.unusedConnectors.add(connector);
                return true;
            }
            return false;
        }

        public Projection getProjectionForExternalNode(String externalNodeKey) {
            return this.projections.get(externalNodeKey);
        }

        public boolean containsProjectionForExternalNode(String externalNodeKey) {
            return this.projections.containsKey(externalNodeKey);
        }

        public boolean containsProjectionForInternalNode(String internalNodeKey) {
            return this.projectedInternalNodeKeys.contains(internalNodeKey);
        }

        protected Snapshot withoutProjection(String externalNodeKey) {
            if (this.projections.containsKey(externalNodeKey)) {
                Projection projection = this.projections.get(externalNodeKey);
                Snapshot clone = new Snapshot(this);
                clone.projections.remove(externalNodeKey);
                clone.projectedInternalNodeKeys.remove(projection.getProjectedNodeKey());
                return clone;
            }
            return this;
        }

        protected Snapshot withoutConnectors(Iterable<Connector> connectors) {
            Snapshot clone = new Snapshot(this);
            boolean modified = false;
            for (Connector connector : connectors) {
                if (!clone.unregisterConnector(connector)) continue;
                modified = true;
            }
            if (modified) {
                this.checkForReadonlyConnectors();
            }
            return modified ? clone : this;
        }

        protected Snapshot withProjection(Projection projection) {
            Snapshot clone = new Snapshot(this);
            clone.projections.put(projection.getExternalNodeKey(), projection);
            clone.projectedInternalNodeKeys.add(projection.getProjectedNodeKey());
            return clone;
        }

        protected Snapshot withoutProjections(Projection ... projections) {
            if (projections.length == 0) {
                return this;
            }
            Snapshot clone = new Snapshot(this);
            for (Projection projection : projections) {
                clone.projections.remove(projection.getExternalNodeKey());
                clone.projectedInternalNodeKeys.remove(projection.getProjectedNodeKey());
            }
            return clone;
        }

        protected Snapshot withProjections(Iterable<Projection> projections) {
            Snapshot clone = new Snapshot(this);
            for (Projection projection : projections) {
                clone.projections.put(projection.getExternalNodeKey(), projection);
                clone.projectedInternalNodeKeys.add(projection.getProjectedNodeKey());
            }
            return clone;
        }

        protected Snapshot withOnlyProjectionConfigurations() {
            return new Snapshot(Collections.emptyList(), this.externalSources, this.preconfiguredProjections);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PathMappings getPathMappings(Connector connector) {
            PathMappings mappings;
            String connectorSourceName = connector.getSourceName();
            if (this.mappingsByConnectorSourceName == null) {
                Snapshot snapshot = this;
                synchronized (snapshot) {
                    if (this.mappingsByConnectorSourceName == null) {
                        JcrRepository.RunningState repository = Connectors.this.repository();
                        PathFactory pathFactory = Connectors.this.repository().context().getValueFactories().getPathFactory();
                        HashMap<String, BasicPathMappings> mappingsByConnectorSourceName = new HashMap<String, BasicPathMappings>();
                        Map<String, String> workspaceNamesByKey = Connectors.this.workspaceNamesByKey();
                        for (Projection projection : this.projections.values()) {
                            String projectedKeyStr;
                            NodeKey projectedKey;
                            String workspaceName;
                            String alias = projection.getAlias();
                            String externalKeyStr = projection.getExternalNodeKey();
                            NodeKey externalKey = new NodeKey(externalKeyStr);
                            String externalDocId = externalKey.getIdentifier();
                            Connector conn = Connectors.this.getConnectorForSourceKey(externalKey.getSourceKey());
                            if (conn == null) {
                                throw new IllegalStateException("External source key: " + externalKey.getSourceKey() + " has no matching connector");
                            }
                            if (conn != connector) continue;
                            BasicPathMappings mappings2 = (BasicPathMappings)mappingsByConnectorSourceName.get(connectorSourceName);
                            if (mappings2 == null) {
                                mappings2 = new BasicPathMappings(connectorSourceName, pathFactory);
                                mappingsByConnectorSourceName.put(connectorSourceName, mappings2);
                            }
                            if ((workspaceName = workspaceNamesByKey.get((projectedKey = new NodeKey(projectedKeyStr = projection.getProjectedNodeKey())).getWorkspaceKey())) == null) continue;
                            try {
                                WorkspaceCache cache = repository.repositoryCache().getWorkspaceCache(workspaceName);
                                AllPathsCache allPathsCache = new AllPathsCache((NodeCache)cache, null, pathFactory);
                                CachedNode node = cache.getNode(projectedKey);
                                for (Path nodePath : allPathsCache.getPaths(node)) {
                                    Path internalPath = pathFactory.create(nodePath, alias);
                                    for (String externalPathStr : conn.getDocumentPathsById(externalDocId)) {
                                        Path externalPath = (Path)pathFactory.create(externalPathStr);
                                        mappings2.add(externalPath, internalPath, workspaceName);
                                    }
                                }
                            }
                            catch (WorkspaceNotFoundException e) {
                            }
                        }
                        for (BasicPathMappings mappings3 : mappingsByConnectorSourceName.values()) {
                            mappings3.freeze();
                        }
                        this.mappingsByConnectorSourceName = mappingsByConnectorSourceName;
                    }
                }
            }
            return (mappings = (PathMappings)this.mappingsByConnectorSourceName.get(connectorSourceName)) != null ? mappings : new EmptyPathMappings(connectorSourceName, Connectors.this.repository().context().getValueFactories().getPathFactory());
        }

        private void checkForReadonlyConnectors() {
            for (Connector connector : this.sourceKeyToConnectorMap.values()) {
                if (!connector.isReadonly()) continue;
                this.hasReadonlyConnectors = true;
                return;
            }
            this.hasReadonlyConnectors = false;
        }

        protected boolean hasReadonlyConnectors() {
            return this.hasReadonlyConnectors;
        }

        protected synchronized boolean isUnused(String sourceName) {
            for (Connector connector : this.unusedConnectors) {
                if (!connector.getSourceName().equals(sourceName)) continue;
                return true;
            }
            return false;
        }
    }
}

