/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.api.federation.FederationManager;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.value.Path;

public class ModeShapeFederationManager
implements FederationManager {
    private final JcrSession session;
    private final DocumentStore documentStore;

    protected ModeShapeFederationManager(JcrSession session, DocumentStore documentStore) {
        this.session = session;
        this.documentStore = documentStore;
    }

    public void createProjection(String absNodePath, String sourceName, String externalPath, String alias) throws RepositoryException {
        String projectionAlias;
        AbstractJcrNode node = this.session.getNode(absNodePath);
        if (this.session.nodeTypeManager().nodeTypes().isUnorderedCollection(node.getPrimaryTypeName(), node.getMixinTypeNames())) {
            throw new ConstraintViolationException(JcrI18n.operationNotSupportedForUnorderedCollections.text(new Object[]{"create projection"}));
        }
        NodeKey parentNodeToBecomeFederatedKey = node.key();
        String string = projectionAlias = !StringUtil.isBlank((String)alias) ? alias : externalPath;
        if (projectionAlias.endsWith("/")) {
            projectionAlias = projectionAlias.substring(0, projectionAlias.length() - 1);
        }
        if (projectionAlias.contains("/")) {
            projectionAlias = projectionAlias.substring(projectionAlias.lastIndexOf("/") + 1);
        }
        if (StringUtil.isBlank((String)projectionAlias)) {
            return;
        }
        SessionCache sessionCache = this.session.spawnSessionCache(false);
        String externalNodeKey = this.documentStore.createExternalProjection(parentNodeToBecomeFederatedKey.toString(), sourceName, externalPath, projectionAlias);
        MutableCachedNode mutable = sessionCache.mutable(parentNodeToBecomeFederatedKey);
        mutable.addFederatedSegment(externalNodeKey, projectionAlias);
        sessionCache.save();
    }

    public void removeProjection(String projectionPath) throws RepositoryException {
        CheckArg.isNotNull((Object)projectionPath, (String)"projectionPath");
        Path path = (Path)this.session.pathFactory().create(projectionPath);
        if (path.isRoot()) {
            throw new IllegalArgumentException(JcrI18n.invalidProjectionPath.text(new Object[]{projectionPath}));
        }
        NodeKey federatedNodeKey = this.session.getNode(path.getParent().getString()).key();
        NodeKey externalNodeKey = this.session.getNode(path.getString()).key();
        SessionCache sessionCache = this.session.spawnSessionCache(false);
        MutableCachedNode federatedNode = sessionCache.mutable(federatedNodeKey);
        federatedNode.removeFederatedSegment(externalNodeKey.toString());
        sessionCache.save();
    }
}

