/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.cache.NodeKey;

@Immutable
public final class ReferrerCounts {
    private static final Map<NodeKey, Integer> EMPTY_COUNTS = Collections.emptyMap();
    private final Map<NodeKey, Integer> strongCountsByReferrerKey;
    private final Map<NodeKey, Integer> weakCountsByReferrerKey;

    public static ReferrerCounts create(Map<NodeKey, Integer> strongCountsByReferrerKey, Map<NodeKey, Integer> weakCountsByReferrerKey) {
        if (strongCountsByReferrerKey == null) {
            strongCountsByReferrerKey = EMPTY_COUNTS;
        }
        if (weakCountsByReferrerKey == null) {
            weakCountsByReferrerKey = EMPTY_COUNTS;
        }
        if (strongCountsByReferrerKey.isEmpty() && weakCountsByReferrerKey.isEmpty()) {
            return null;
        }
        return new ReferrerCounts(strongCountsByReferrerKey, weakCountsByReferrerKey);
    }

    public static MutableReferrerCounts createMutable() {
        return new MutableReferrerCounts(null);
    }

    protected static int count(Integer count) {
        return count != null ? count : 0;
    }

    protected ReferrerCounts(Map<NodeKey, Integer> strongCountsByReferrerKey, Map<NodeKey, Integer> weakCountsByReferrerKey) {
        assert (strongCountsByReferrerKey != null);
        assert (weakCountsByReferrerKey != null);
        this.strongCountsByReferrerKey = strongCountsByReferrerKey;
        this.weakCountsByReferrerKey = weakCountsByReferrerKey;
    }

    public Set<NodeKey> getStrongReferrers() {
        return this.strongCountsByReferrerKey.keySet();
    }

    public Set<NodeKey> getWeakReferrers() {
        return this.weakCountsByReferrerKey.keySet();
    }

    public int countStrongReferencesFrom(NodeKey referrer) {
        return ReferrerCounts.count(this.strongCountsByReferrerKey.get(referrer));
    }

    public int countWeakReferencesFrom(NodeKey referrer) {
        return ReferrerCounts.count(this.weakCountsByReferrerKey.get(referrer));
    }

    public MutableReferrerCounts mutable() {
        return new MutableReferrerCounts(this);
    }

    public static final class MutableReferrerCounts {
        private final Map<NodeKey, Integer> strongCountsByReferrerKey = new HashMap<NodeKey, Integer>();
        private final Map<NodeKey, Integer> weakCountsByReferrerKey = new HashMap<NodeKey, Integer>();

        protected MutableReferrerCounts(ReferrerCounts counts) {
            if (counts != null) {
                for (NodeKey key : counts.getStrongReferrers()) {
                    this.strongCountsByReferrerKey.put(key, counts.countStrongReferencesFrom(key));
                }
                for (NodeKey key : counts.getStrongReferrers()) {
                    this.weakCountsByReferrerKey.put(key, counts.countWeakReferencesFrom(key));
                }
            }
        }

        public MutableReferrerCounts addStrong(NodeKey key, int increment) {
            this.change(key, increment, this.strongCountsByReferrerKey);
            return this;
        }

        public MutableReferrerCounts addWeak(NodeKey key, int increment) {
            this.change(key, increment, this.weakCountsByReferrerKey);
            return this;
        }

        public ReferrerCounts freeze() {
            return ReferrerCounts.create(this.strongCountsByReferrerKey, this.weakCountsByReferrerKey);
        }

        private void change(NodeKey key, int increment, Map<NodeKey, Integer> counts) {
            if (key == null) {
                return;
            }
            int count = ReferrerCounts.count(counts.get(key)) + increment;
            if (count > 0) {
                counts.put(key, count);
            } else {
                counts.remove(key);
            }
        }
    }
}

