/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.modeshape.common.CommonI18n;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.value.InvalidPathException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.basic.BasicPath;
import org.modeshape.jcr.value.basic.RootPath;

@Immutable
public abstract class AbstractPath
implements Path {
    private static final long serialVersionUID = 1L;
    public static final Path SELF_PATH = new BasicPath(Collections.singletonList(Path.SELF_SEGMENT), false);
    protected static Iterator<Path.Segment> EMPTY_PATH_ITERATOR = new Iterator<Path.Segment>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Path.Segment next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private transient int hc = 0;

    protected boolean isNormalized(List<Path.Segment> segments) {
        boolean nonParentReference = false;
        boolean first = this.isAbsolute();
        for (Path.Segment segment : segments) {
            if (segment.isSelfReference()) {
                return false;
            }
            if (segment.isParentReference()) {
                if (nonParentReference || first) {
                    return false;
                }
            } else {
                nonParentReference = true;
            }
            first = false;
        }
        return true;
    }

    @Override
    public boolean isIdentifier() {
        return false;
    }

    @Override
    public Path getCanonicalPath() {
        if (!this.isAbsolute()) {
            String msg = GraphI18n.pathIsNotAbsolute.text(new Object[]{this});
            throw new InvalidPathException(msg);
        }
        if (this.isNormalized()) {
            return this;
        }
        return this.getNormalizedPath();
    }

    @Override
    public Path getCommonAncestor(Path that) {
        Path.Segment thatSeg;
        Path.Segment thisSeg;
        CheckArg.isNotNull((Object)that, (String)"that");
        if (that.isRoot()) {
            return that;
        }
        Path normalizedPath = this.getNormalizedPath();
        int lastIndex = 0;
        Iterator thisIter = normalizedPath.iterator();
        Iterator thatIter = that.getNormalizedPath().iterator();
        while (thisIter.hasNext() && thatIter.hasNext() && (thisSeg = (Path.Segment)thisIter.next()).equals(thatSeg = (Path.Segment)thatIter.next())) {
            ++lastIndex;
        }
        if (lastIndex == 0) {
            return RootPath.INSTANCE;
        }
        return normalizedPath.subpath(0, lastIndex);
    }

    @Override
    public Path.Segment getLastSegment() {
        return this.getSegmentsList().get(this.size() - 1);
    }

    @Override
    public boolean endsWith(Name nameOfLastSegment) {
        Path.Segment segment = this.getLastSegment();
        return segment != null && segment.getName().equals(nameOfLastSegment) && !segment.hasIndex();
    }

    @Override
    public boolean endsWith(Name nameOfLastSegment, int snsIndex) {
        Path.Segment segment = this.getLastSegment();
        return segment != null && segment.getName().equals(nameOfLastSegment) && segment.getIndex() == snsIndex;
    }

    @Override
    public Path getParent() {
        return this.getAncestor(1);
    }

    @Override
    public Path.Segment getSegment(int index) {
        CheckArg.isNonNegative((int)index, (String)"index");
        return this.getSegmentsList().get(index);
    }

    @Override
    public Path.Segment[] getSegmentsArray() {
        Path.Segment[] result = new Path.Segment[this.size()];
        int i = 0;
        Iterator<Path.Segment> i$ = this.iterator();
        while (i$.hasNext()) {
            Path.Segment segment;
            result[i] = segment = i$.next();
            ++i;
        }
        return result;
    }

    @Override
    public Path getNormalizedPath() {
        if (this.isNormalized()) {
            return this;
        }
        LinkedList<Path.Segment> newSegments = new LinkedList<Path.Segment>();
        for (Path.Segment segment : this) {
            if (segment.isSelfReference()) continue;
            if (segment.isParentReference()) {
                if (newSegments.isEmpty()) {
                    if (this.isAbsolute()) {
                        throw new InvalidPathException(CommonI18n.pathCannotBeNormalized.text(new Object[]{this}));
                    }
                } else if (!newSegments.getLast().isParentReference()) {
                    newSegments.removeLast();
                    continue;
                }
            }
            newSegments.add(segment);
        }
        if (newSegments.isEmpty()) {
            if (this.isAbsolute()) {
                return RootPath.INSTANCE;
            }
            return SELF_PATH;
        }
        return new BasicPath(newSegments, this.isAbsolute());
    }

    @Override
    public String getString() {
        return this.doGetString(null, null, null);
    }

    @Override
    public String getString(TextEncoder encoder) {
        return this.doGetString(null, encoder, null);
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        return this.doGetString(namespaceRegistry, null, null);
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        return this.doGetString(namespaceRegistry, encoder, null);
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        return this.doGetString(namespaceRegistry, encoder, delimiterEncoder);
    }

    protected String doGetString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        if (encoder == null) {
            encoder = DEFAULT_ENCODER;
        }
        String delimiter = delimiterEncoder != null ? delimiterEncoder.encode(DELIMITER_STR) : DELIMITER_STR;
        StringBuilder sb = new StringBuilder();
        if (this.isAbsolute()) {
            sb.append(delimiter);
        }
        boolean first = true;
        for (Path.Segment segment : this) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            assert (segment != null);
            sb.append(segment.getString(namespaceRegistry, encoder, delimiterEncoder));
        }
        String result = sb.toString();
        return result;
    }

    @Override
    public boolean hasSameAncestor(Path that) {
        CheckArg.isNotNull((Object)that, (String)"that");
        if (that.size() != this.size()) {
            return false;
        }
        if (this.size() == 1) {
            return true;
        }
        for (int i = this.size() - 2; i >= 0; --i) {
            Path.Segment thatSegment;
            Path.Segment thisSegment = this.getSegment(i);
            if (thisSegment.equals(thatSegment = that.getSegment(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAncestorOf(Path descendant) {
        CheckArg.isNotNull((Object)descendant, (String)"descendant");
        return descendant.isDescendantOf(this);
    }

    @Override
    public boolean isAtOrBelow(Path other) {
        CheckArg.isNotNull((Object)other, (String)"other");
        if (this == other) {
            return true;
        }
        if (other.isRoot()) {
            return true;
        }
        if (other.size() > this.size()) {
            return false;
        }
        Path thisPath = this.getAncestor(this.size() - other.size());
        Path thatPath = other;
        assert (thisPath.size() == other.size());
        while (!thisPath.isRoot() && thisPath.getLastSegment().equals(thatPath.getLastSegment())) {
            thisPath = thisPath.getParent();
            thatPath = thatPath.getParent();
        }
        return thisPath.isRoot();
    }

    @Override
    public boolean isAtOrAbove(Path other) {
        CheckArg.isNotNull((Object)other, (String)"other");
        return other.isAtOrBelow(this);
    }

    @Override
    public boolean isDescendantOf(Path ancestor) {
        CheckArg.isNotNull((Object)ancestor, (String)"ancestor");
        if (this == ancestor) {
            return false;
        }
        if (ancestor.isRoot()) {
            return true;
        }
        if (ancestor.size() >= this.size()) {
            return false;
        }
        Path thisPath = this.getAncestor(this.size() - ancestor.size());
        Path thatPath = ancestor;
        assert (thisPath.size() == thatPath.size());
        while (!thisPath.isRoot() && thisPath.getLastSegment().equals(thatPath.getLastSegment())) {
            thisPath = thisPath.getParent();
            thatPath = thatPath.getParent();
        }
        return thisPath.isRoot();
    }

    @Override
    public boolean isSameAs(Path other) {
        return other != null && this.compareTo(other) == 0;
    }

    @Override
    public Iterator<Path.Segment> iterator() {
        return this.getSegmentsList().iterator();
    }

    @Override
    public Iterator<Path> pathsFromRoot() {
        LinkedList<AbstractPath> paths = new LinkedList<AbstractPath>();
        for (Path path = this; path != null; path = path.getParent()) {
            paths.addFirst((AbstractPath)path);
            if (path.isRoot()) break;
        }
        return paths.iterator();
    }

    @Override
    public Path relativeToRoot() {
        return new BasicPath(this.getSegmentsList(), false);
    }

    @Override
    public Path relativeTo(Path startingPath) {
        int i;
        Path.Segment toSeg;
        Path.Segment thisSeg;
        CheckArg.isNotNull((Object)startingPath, (String)"to");
        if (!this.isAbsolute()) {
            String msg = GraphI18n.pathIsNotAbsolute.text(new Object[]{this});
            throw new InvalidPathException(msg);
        }
        if (startingPath.isRoot()) {
            return this.relativeToRoot();
        }
        if (!startingPath.isAbsolute()) {
            String msg = GraphI18n.pathIsNotAbsolute.text(new Object[]{startingPath});
            throw new InvalidPathException(msg);
        }
        int lengthOfCommonAncestor = 0;
        Iterator thisIter = this.getNormalizedPath().iterator();
        Iterator toIter = startingPath.getNormalizedPath().iterator();
        while (thisIter.hasNext() && toIter.hasNext() && (thisSeg = (Path.Segment)thisIter.next()).equals(toSeg = (Path.Segment)toIter.next())) {
            ++lengthOfCommonAncestor;
        }
        int numberOfParentReferences = startingPath.size() - lengthOfCommonAncestor;
        ArrayList<Path.Segment> relativeSegments = new ArrayList<Path.Segment>();
        for (i = 0; i != numberOfParentReferences; ++i) {
            relativeSegments.add(Path.PARENT_SEGMENT);
        }
        for (i = lengthOfCommonAncestor; i < this.size(); ++i) {
            relativeSegments.add(this.getSegment(i));
        }
        if (relativeSegments.isEmpty()) {
            relativeSegments.add(Path.SELF_SEGMENT);
        }
        return new BasicPath(relativeSegments, false);
    }

    @Override
    public Path resolve(Path relativePath) {
        CheckArg.isNotNull((Object)relativePath, (String)"relative path");
        if (!this.isAbsolute()) {
            String msg = GraphI18n.pathIsNotAbsolute.text(new Object[]{this});
            throw new InvalidPathException(msg);
        }
        if (relativePath.isAbsolute()) {
            String msg = GraphI18n.pathIsNotRelative.text(new Object[]{relativePath});
            throw new InvalidPathException(msg);
        }
        if ((relativePath = relativePath.getNormalizedPath()).size() == 1) {
            Path.Segment onlySegment = relativePath.getSegment(0);
            if (onlySegment.isSelfReference()) {
                return this;
            }
            if (onlySegment.isParentReference()) {
                return this.getParent();
            }
        }
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(this.size() + relativePath.size());
        for (Path.Segment segment : this) {
            segments.add(segment);
        }
        for (Path.Segment segment : relativePath) {
            segments.add(segment);
        }
        return new BasicPath(segments, true).getNormalizedPath();
    }

    @Override
    public Path resolveAgainst(Path absolutePath) {
        CheckArg.isNotNull((Object)absolutePath, (String)"absolute path");
        return absolutePath.resolve(this);
    }

    @Override
    public Path subpath(int beginIndex) {
        return this.subpath(beginIndex, this.size());
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        CheckArg.isNonNegative((int)beginIndex, (String)"beginIndex");
        CheckArg.isNonNegative((int)endIndex, (String)"endIndex");
        int size = this.size();
        if (beginIndex == 0) {
            if (endIndex == 0) {
                return RootPath.INSTANCE;
            }
            if (endIndex == size) {
                return this;
            }
        }
        if (beginIndex >= size) {
            throw new IndexOutOfBoundsException(GraphI18n.unableToCreateSubpathBeginIndexGreaterThanOrEqualToSize.text(new Object[]{beginIndex, size}));
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(GraphI18n.unableToCreateSubpathBeginIndexGreaterThanOrEqualToEndingIndex.text(new Object[]{beginIndex, endIndex}));
        }
        return new BasicPath(this.createSegmentsSubList(beginIndex, endIndex), this.isAbsolute());
    }

    protected List<Path.Segment> createSegmentsSubList(int validBeginIndex, int validEndIndex) {
        return this.getSegmentsList().subList(validBeginIndex, validEndIndex);
    }

    public int hashCode() {
        if (this.hc == 0) {
            int hashCode = 1;
            for (Path.Segment segment : this) {
                hashCode = 31 * hashCode + segment.hashCode();
            }
            this.hc = hashCode;
        }
        return this.hc;
    }

    protected abstract Iterator<Path.Segment> getSegmentsOfParent();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path) {
            Iterator<Object> thatIter;
            Path that = (Path)obj;
            if (this.isRoot()) {
                return that.isRoot();
            }
            if (that.isRoot()) {
                return false;
            }
            if (this.hashCode() != that.hashCode()) {
                return false;
            }
            if (this.size() != that.size()) {
                return false;
            }
            if (!this.getLastSegment().equals(that.getLastSegment())) {
                return false;
            }
            if (this.size() == 1) {
                return true;
            }
            Iterator<Path.Segment> thisIter = that instanceof AbstractPath ? this.getSegmentsOfParent() : this.iterator();
            Iterator<Object> iterator = thatIter = that instanceof AbstractPath ? ((AbstractPath)that).getSegmentsOfParent() : that.iterator();
            while (thisIter.hasNext()) {
                Path.Segment thatSegment;
                Path.Segment thisSegment = thisIter.next();
                if (thisSegment.equals(thatSegment = (Path.Segment)thatIter.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Path that) {
        if (this == that) {
            return 0;
        }
        Iterator<Path.Segment> thisIter = this.getSegmentsList().iterator();
        Iterator thatIter = that.iterator();
        while (thisIter.hasNext() && thatIter.hasNext()) {
            Path.Segment thatSegment;
            Path.Segment thisSegment = thisIter.next();
            int diff = thisSegment.compareTo(thatSegment = (Path.Segment)thatIter.next());
            if (diff == 0) continue;
            return diff;
        }
        if (thisIter.hasNext()) {
            return 1;
        }
        if (thatIter.hasNext()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.getString(Path.NO_OP_ENCODER);
    }
}

