/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.XaTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransactionTable;

@DefaultFactoryFor(classes={TransactionTable.class})
public class TransactionTableFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        if (this.configuration.invocationBatching().enabled()) {
            return (T)new TransactionTable();
        }
        if (!this.configuration.transaction().useSynchronization()) {
            if (this.configuration.transaction().recovery().enabled()) {
                return (T)new RecoveryAwareTransactionTable();
            }
            return (T)new XaTransactionTable();
        }
        return (T)new TransactionTable();
    }
}

