/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Project;
import com.xebialabs.xltest.domain.TestToolFactory;
import com.xebialabs.xltest.domain.TestToolNameAware;
import com.xebialabs.xltest.repository.ProjectRepository;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.repository.TestToolRepository;
import com.xebialabs.xltest.serialize.TestSpecificationStatusStream;
import com.xebialabs.xltest.utils.JcrUtils;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.minidev.json.JSONObject;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/testspecifications")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class TestSpecificationInternalController {
    private TestSpecificationRepository testSpecificationRepository;
    private ProjectRepository projectRepository;
    private final TestToolRepository testToolRepository;
    private TestSpecificationStatusStream testSpecificationStatusStream;

    @Autowired
    public TestSpecificationInternalController(TestSpecificationRepository testSpecificationRepository, ProjectRepository projectRepository, TestToolRepository testToolRepository, TestSpecificationStatusStream testSpecificationStatusStream) {
        this.testSpecificationRepository = testSpecificationRepository;
        this.projectRepository = projectRepository;
        this.testSpecificationStatusStream = testSpecificationStatusStream;
        this.testToolRepository = testToolRepository;
    }

    @GET
    @Path(value="/")
    public Response getTestSpecificationsStatusesForProject() {
        return Response.ok(this.testSpecificationRepository.getAll()).build();
    }

    @GET
    @Path(value="/extended")
    public Response getTestSpecificationsForDisplay() {
        List<BaseTestSpecification> testSpecifications = this.testSpecificationRepository.getAll();
        JSONObject result = new JSONObject();
        for (BaseTestSpecification spec : testSpecifications) {
            JSONObject tjs = new JSONObject();
            tjs.put((Object)"id", (Object)spec.getName());
            tjs.put((Object)"title", (Object)spec.getTitle());
            tjs.put((Object)"type", (Object)spec.getType().toString());
            if (spec.hasQualificationType()) {
                JSONObject qjs = new JSONObject();
                qjs.put((Object)"type", (Object)spec.getQualificationType());
                qjs.put((Object)"description", (Object)spec.getQualification().getType().getDescriptor().getDescription());
                tjs.put((Object)"qualification", (Object)qjs);
            }
            String projectId = JcrUtils.getParentId(spec.getId());
            Project project = this.projectRepository.getProject(projectId);
            JSONObject pjs = new JSONObject();
            pjs.put((Object)"id", (Object)project.getName());
            pjs.put((Object)"title", (Object)project.getTitle());
            pjs.put((Object)"type", (Object)project.getType().toString());
            tjs.put((Object)"project", (Object)pjs);
            if (spec instanceof TestToolNameAware) {
                String testToolName = ((TestToolNameAware)((Object)spec)).getTestToolName();
                TestToolFactory testTool = this.testToolRepository.findTestToolConfigurationByName(testToolName);
                JSONObject ttjs = new JSONObject();
                ttjs.put((Object)"name", (Object)testTool.getName());
                ttjs.put((Object)"category", (Object)testTool.getCategory());
                ttjs.put((Object)"defaultSearchPattern", (Object)testTool.getDefaultSearchPattern());
                tjs.put((Object)"testTool", (Object)ttjs);
            }
            result.put((Object)spec.getName(), (Object)tjs);
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/{testSpecificationId}")
    public Response getTestSpecification(@PathParam(value="testSpecificationId") String testSpecificationId) {
        return Response.ok((Object)((Object)this.testSpecificationRepository.getById(testSpecificationId))).build();
    }

    @GET
    @Path(value="/{testSpecificationName:.+}/reports")
    public Response findReportsForTestSpecification(@PathParam(value="testSpecificationName") String testSpecificationId) {
        List<Descriptor> reportsForTestSpecification = this.testSpecificationRepository.findReportsForTestSpecification(testSpecificationId);
        return Response.ok().entity(reportsForTestSpecification).build();
    }

    @GET
    @Path(value="/{testSpecificationId}/status")
    @Produces(value={"text/event-stream"})
    public void getTestSpecificationsStatusFeed(@PathParam(value="testSpecificationId") String testSpecificationId, @Context HttpServletResponse response) throws Exception {
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Connection", "keep-alive");
        PrintWriter writer = response.getWriter();
        this.testSpecificationStatusStream.getSpecificationStatus(testSpecificationId, writer);
    }
}

