/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.v1;

import com.xebialabs.xltest.api.requests.ImportTestResultsRequest;
import com.xebialabs.xltest.service.ImportService;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/v1/projects")
@Produces(value={"application/json"})
@NoCache
public class ImportController {
    private static final Logger LOG = LoggerFactory.getLogger(ImportController.class);
    private final ImportService importService;

    @Autowired
    public ImportController(ImportService importService) {
        this.importService = importService;
    }

    @POST
    @Path(value="/{projectId}/testspecifications/{testSpecificationId}/testruns")
    @Consumes(value={"multipart/mixed"})
    public Response importTestResults(@PathParam(value="testSpecificationId") String testSpecificationId, MultipartInput parts, @Context HttpServletRequest request) throws Exception {
        try (ImportTestResultsRequest importTestResultsRequest = new ImportTestResultsRequest(parts);){
            importTestResultsRequest.validateMetadata();
            LOG.info("Received import for testSpecificationId={}", (Object)testSpecificationId);
            InputStream inputStream = importTestResultsRequest.getInputStream();
            JSONObject result = (JSONObject)this.importService.importTestResultsFromZIPInputStream(testSpecificationId, inputStream, importTestResultsRequest.getMetadata()).map(this::makeJsonResponse).toBlocking().first();
            Response response = Response.ok((Object)result.toString()).build();
            return response;
        }
    }

    private JSONObject makeJsonResponse(List<String> testRunIds) {
        try {
            JSONObject resp = new JSONObject();
            resp.put("testRunId", testRunIds);
            return resp;
        }
        catch (JSONException e) {
            throw new RuntimeException("Could not form JSON", e);
        }
    }
}

