/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.Executable;
import com.xebialabs.xltest.view.ExecutionParameterRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="Executable Test Specification", description="A test specification that can execute test runs", root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false)
public class ExecutableTestSpecification
extends ActiveTestSpecification
implements Executable {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutableTestSpecification.class);
    @Property(description="Command to execute this test set", category="Execution")
    private String commandLine;
    @Property(description="Maximum number of minutes this test set is allowed to execute", required=true, category="Execution", defaultValue="10")
    private Integer timeout;
    @Property(description="Location of the script on the class path", required=false, defaultValue="", hidden=true)
    private String scriptLocation;

    @Override
    public boolean updateExecutionProperties(String commandLine, Host host) {
        if (host != null) {
            LOG.debug("Updating host to {}", (Object)host);
            this.setHost(host);
        }
        if (commandLine != null) {
            LOG.debug("Updating commandline to {}", (Object)commandLine);
            this.commandLine = commandLine;
        }
        return this.isExecutable();
    }

    @Override
    public ExecutionParameterRequest toExecutionParameterRequest() {
        return new ExecutionParameterRequest(this.commandLine, this.getHost() != null ? this.getHost().getId() : null, this.getParameters());
    }

    private Map<String, Set<String>> getParameters() {
        HashMap<String, Set<String>> parameterMap = new HashMap<String, Set<String>>();
        Collection propertyDescriptors = this.getType().getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!"Parameters".equalsIgnoreCase(propertyDescriptor.getCategory())) continue;
            String key = propertyDescriptor.getName();
            String value = (String)propertyDescriptor.get((ConfigurationItem)this);
            parameterMap.put(key, Sets.newHashSet((Object[])new String[]{value}));
        }
        return parameterMap;
    }

    public static String[] parseCommandLine(String commandLine) {
        if (commandLine == null) {
            return new String[]{""};
        }
        ArrayList<String> result = new ArrayList<String>();
        Pattern p = Pattern.compile("\"([^\"]*)\"|[\\S]+");
        Matcher m = p.matcher(commandLine);
        while (m.find()) {
            String token = m.group(1) == null ? m.group(0) : m.group(1);
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public static boolean isExecutable(String commandLine, Host host) {
        return !Strings.isNullOrEmpty((String)commandLine) && host != null;
    }

    @Override
    public boolean isExecutable() {
        return ExecutableTestSpecification.isExecutable(this.commandLine, this.getHost());
    }

    public String getScriptLocation() {
        return this.scriptLocation;
    }

    public void setScriptLocation(String scriptLocation) {
        this.scriptLocation = scriptLocation;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public CmdLine getCmdLine() {
        return CmdLine.build((String[])ExecutableTestSpecification.parseCommandLine(this.commandLine));
    }

    public CmdLine getCmdLine(String resolvedCommandLine) {
        return CmdLine.build((String[])ExecutableTestSpecification.parseCommandLine(resolvedCommandLine));
    }

    public static ExecutableTestSpecification newInstance(String id) {
        return (ExecutableTestSpecification)Type.valueOf(ExecutableTestSpecification.class).getDescriptor().newInstance(id);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("commandLine", (Object)this.commandLine).add("timeout", (Object)this.timeout).add("scriptLocation", (Object)this.scriptLocation).toString();
    }
}

