/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlt.plugin.api.repository.QualificationsRepository;
import com.xebialabs.xlt.plugin.api.testrun.TestRun;
import com.xebialabs.xlt.plugin.api.testrun.TestRunsRepository;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.domain.TestSpecificationSet;
import java.io.FileNotFoundException;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.script.ScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(description="Report base type.", root=Metadata.ConfigurationItemRoot.CONFIGURATION, virtual=true, versioned=false)
public class Report
extends ScriptedConfigurationItem {
    private static final Logger LOG = LoggerFactory.getLogger(Report.class);
    @Property(description="The type of report. One of 'link', 'highchart', 'table', 'html', 'qualification'.")
    private String reportType;
    @Property(description="The name of the file holding the icon for this report.")
    private String iconName;
    @Property(description="Category of test tools for which this report is applicable.", defaultValue="functional")
    private Set<String> applicableCategories = Sets.newHashSet((Object[])new String[]{"functional"});
    @Property(description="Some reports belong to test specifications. Others to test-run 'level'.", required=false, defaultValue="true")
    private boolean visibleOnTestSpecificationLevel = true;
    private Map<String, Object> attributes = new TreeMap<String, Object>();

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public String getDescription() {
        return this.getType().getDescriptor().getDescription();
    }

    public Set<String> getApplicableCategories() {
        return this.applicableCategories;
    }

    public void setApplicableCategories(Set<String> applicableCategories) {
        this.applicableCategories = applicableCategories;
    }

    public boolean isVisibleOnTestSpecificationLevel() {
        return this.visibleOnTestSpecificationLevel;
    }

    public void setVisibleOnTestSpecificationLevel(boolean visibleOnTestSpecificationLevel) {
        this.visibleOnTestSpecificationLevel = visibleOnTestSpecificationLevel;
    }

    @Deprecated
    public String getTitle() {
        LOG.warn("getTitle() is deprecated. Please update any python scripts");
        return this.getLabel();
    }

    public String getLabel() {
        return this.getType().getDescriptor().getLabel();
    }

    public Object computeForTestSet(TestRunsRepository testRunsRepository, QualificationsRepository qualificationsRepository, TestSpecificationSet testSpecificationSet) {
        LOG.debug("compute reportId={} without testRunId.", (Object)this.getId());
        ScriptContext context = this.newScriptContext();
        this.attributes.forEach((k, v) -> context.setAttribute((String)k, v, 100));
        context.setAttribute("test_runs_repository", testRunsRepository, 100);
        context.setAttribute("qualification_repository", qualificationsRepository, 100);
        context.setAttribute("test_specification_set", testSpecificationSet, 100);
        return this.compute(context);
    }

    public Object compute(TestRun testRun, TestRunsRepository testRunsRepository) {
        LOG.debug("compute reportId={} testRunId={}", (Object)this.getId(), (Object)testRun.getId());
        ScriptContext context = this.newScriptContext();
        this.attributes.forEach((k, v) -> context.setAttribute((String)k, v, 100));
        context.setAttribute("test_run", testRun, 100);
        context.setAttribute("test_runs", testRunsRepository, 100);
        return this.compute(context);
    }

    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public <T> T getAttribute(String key) {
        return (T)this.attributes.get(key);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public int compareTo(BaseConfigurationItem o) {
        if (!(o instanceof Report)) {
            return super.compareTo(o);
        }
        Report other = (Report)o;
        return ComparisonChain.start().compare((Object)this.getLabel(), (Object)other.getLabel(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)this.getReportType(), (Object)other.getReportType(), (Comparator)Ordering.natural().nullsFirst()).compare((Comparable)((Object)this.getId()), (Comparable)((Object)this.getId())).result();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("reportType", (Object)this.reportType).add("iconName", (Object)this.iconName).add("applicableCategories", this.applicableCategories).add("visibleOnTestSpecificationLevel", this.visibleOnTestSpecificationLevel).add("attributes", this.attributes).toString();
    }

    private Object compute(ScriptContext context) {
        try {
            LOG.debug("Start generating report reportId={} title={}", (Object)this.getId(), (Object)this.getLabel());
            Object result = this.execute(context, this);
            LOG.debug("Done generating report reportId={} title={}", (Object)this.getId(), (Object)this.getLabel());
            return result;
        }
        catch (FileNotFoundException fnfe) {
            LOG.error("Error generating report reportId={} file not found: {}", (Object)this.getId(), (Object)fnfe.getMessage());
            throw new RuntimeException("Could not perform report transformation.", fnfe);
        }
        catch (Exception e) {
            LOG.error("Error generating report reportId={} error: {}", (Object)this.getId(), (Object)e.getMessage());
            throw new RuntimeException("Could not perform report transformation.", e);
        }
    }
}

