/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Executable;
import com.xebialabs.xltest.view.ExecutionParameterRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="Test Specification Set", description="A group that aggregates the results of multiple test specifications", root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false)
public class TestSpecificationSet
extends BaseTestSpecification
implements Executable {
    private static final Logger LOG = LoggerFactory.getLogger(TestSpecificationSet.class);
    @Property(required=false, description="The list of test specifications this set aggregates")
    private List<BaseTestSpecification> testSpecifications = Collections.emptyList();

    @Override
    public boolean isExecutable() {
        for (BaseTestSpecification baseTestSpecification : this.testSpecifications) {
            Executable executable;
            if (!(baseTestSpecification instanceof Executable) || !(executable = (Executable)((Object)baseTestSpecification)).isExecutable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean updateExecutionProperties(String commandLine, Host hostId) {
        return false;
    }

    @Override
    public ExecutionParameterRequest toExecutionParameterRequest() {
        return new ExecutionParameterRequest("super", "super", this.getParameters());
    }

    public Map<String, Set<String>> getParameters() {
        HashMap<String, Set<String>> parameters = new HashMap<String, Set<String>>();
        for (BaseTestSpecification eachChildTestSpec : this.getTestSpecifications()) {
            if (!(eachChildTestSpec instanceof Executable)) continue;
            ExecutionParameterRequest executionParameterRequest = ((Executable)((Object)eachChildTestSpec)).toExecutionParameterRequest();
            this.mergeParameters(parameters, executionParameterRequest.getParameters());
        }
        return parameters;
    }

    private void mergeParameters(Map<String, Set<String>> parameters, Map<String, Set<String>> testSpecificationParameters) {
        for (Map.Entry<String, Set<String>> paramEntry : testSpecificationParameters.entrySet()) {
            if (parameters.containsKey(paramEntry.getKey())) {
                parameters.get(paramEntry.getKey()).addAll((Collection<String>)paramEntry.getValue());
                continue;
            }
            parameters.put(paramEntry.getKey(), paramEntry.getValue());
        }
    }

    public List<BaseTestSpecification> getTestSpecifications() {
        return this.testSpecifications;
    }

    public List<Executable> getExecutableSpecifications() {
        return this.testSpecifications.stream().filter(child -> child instanceof Executable).map(child -> (Executable)((Object)child)).collect(Collectors.toList());
    }

    public void setTestSpecifications(List<BaseTestSpecification> testSpecifications) {
        this.testSpecifications = testSpecifications;
    }

    public Set<BaseTestSpecification> getAllChildren() {
        HashSet allChildren = Sets.newHashSet();
        for (BaseTestSpecification each : this.getTestSpecifications()) {
            if (each instanceof TestSpecificationSet) {
                allChildren.addAll(((TestSpecificationSet)each).getAllChildren());
                continue;
            }
            allChildren.add(each);
        }
        return allChildren;
    }

    public static TestSpecificationSet newInstance(String id) {
        return (TestSpecificationSet)Type.valueOf(TestSpecificationSet.class).getDescriptor().newInstance(id);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("title", (Object)this.getTitle()).add("testSpecifications", this.testSpecifications).toString();
    }
}

