/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlt.plugin.api.testrun.TestRunsRepository;
import com.xebialabs.xltest.api.v1.dto.TestSpecificationResponse;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Executable;
import com.xebialabs.xltest.domain.PassiveTestSpecification;
import com.xebialabs.xltest.domain.QualificationResult;
import com.xebialabs.xltest.repository.ProjectRepository;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TestSpecificationTreeBuilder {
    private final ProjectRepository projectRepository;
    private final TestSpecificationRepository testSpecificationRepository;
    private TestRunsRepository testRunsRepository;

    @Autowired
    public TestSpecificationTreeBuilder(ProjectRepository projectRepository, TestSpecificationRepository testSpecificationRepository, TestRunsRepository testRunsRepository) {
        this.projectRepository = projectRepository;
        this.testSpecificationRepository = testSpecificationRepository;
        this.testRunsRepository = testRunsRepository;
    }

    public JSONArray treeForTestSpecification(String projectId) throws JSONException {
        List<BaseTestSpecification> allTestSpecifications = this.projectRepository.getTestSpecifications(projectId);
        if (allTestSpecifications == null) {
            allTestSpecifications = Collections.emptyList();
        }
        Collections.sort(allTestSpecifications, BaseTestSpecification.titleComparator);
        return this.createTestSpecificationTree(allTestSpecifications);
    }

    public List<TestSpecificationResponse> treeForPassiveTestSpecification(String projectId, Map<String, String> queryParams) throws JSONException {
        this.projectRepository.validateProjectExists(projectId);
        if (this.projectRepository.getProject(projectId) == null) {
            throw new NotFoundException("'%s' does not exist", new Object[]{projectId});
        }
        List<BaseTestSpecification> allTestSpecifications = this.projectRepository.getTestSpecifications(projectId, PassiveTestSpecification.class, queryParams);
        if (allTestSpecifications == null) {
            allTestSpecifications = Collections.emptyList();
        }
        Collections.sort(allTestSpecifications, BaseTestSpecification.titleComparator);
        return TestSpecificationResponse.createFrom(allTestSpecifications);
    }

    protected JSONArray createTestSpecificationTree(List<BaseTestSpecification> allTestSpecifications) throws JSONException {
        return this.createTestSpecificationTree(allTestSpecifications, null);
    }

    protected JSONArray createTestSpecificationTree(List<BaseTestSpecification> allTestSpecifications, BaseTestSpecification parent) throws JSONException {
        JSONArray jArray = new JSONArray();
        for (BaseTestSpecification testSpec : allTestSpecifications) {
            JSONObject child = new JSONObject();
            child.put("id", (Object)testSpec.getId());
            child.put("name", (Object)testSpec.getName());
            child.put("title", (Object)testSpec.getTitle());
            child.put("type", (Object)testSpec.getType());
            if (parent != null) {
                child.put("parent", (Object)parent.getName());
            }
            if (testSpec.hasProperty("testToolName")) {
                String testToolName = (String)testSpec.getProperty("testToolName");
                child.put("testToolName", (Object)testToolName);
            }
            child.put("hasRuns", this.testRunsRepository.hasTestRuns(testSpec.getName()));
            Optional<QualificationResult> optional = this.testSpecificationRepository.getLatestQualificationResult(testSpec);
            if (optional.isPresent()) {
                QualificationResult qualificationResult = (QualificationResult)((Object)optional.get());
                if (qualificationResult.getResult() == QualificationResult.Result.PASSED) {
                    child.put("result", true);
                } else if (qualificationResult.getResult() == QualificationResult.Result.FAILED) {
                    child.put("result", false);
                }
                if (!Strings.isNullOrEmpty((String)qualificationResult.getLastFailureReason())) {
                    child.put("message", (Object)qualificationResult.getLastFailureReason());
                }
            }
            child.put("executable", testSpec instanceof Executable && ((Executable)((Object)testSpec)).isExecutable());
            child.put("importable", testSpec instanceof ActiveTestSpecification && !(testSpec instanceof Executable));
            if (testSpec.hasProperty("testSpecifications")) {
                List children = (List)testSpec.getProperty("testSpecifications");
                child.put("testSpecifications", (Object)this.createTestSpecificationTree(children, testSpec));
            }
            jArray.put((Object)child);
        }
        return jArray;
    }
}

