/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xltest.repository.EventRepository;
import java.util.List;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.TermFilterBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HealthService {
    private static final Logger LOG = LoggerFactory.getLogger(HealthService.class);
    private final EventRepository eventRepository;

    @Autowired
    public HealthService(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    public boolean isElasticSearchConsistent() {
        List<Event> importFinished = this.eventRepository.query((FilterBuilder)FilterBuilders.typeFilter((String)"importFinished"), (SortBuilder)SortBuilders.fieldSort((String)"@createdAt").order(SortOrder.DESC), Integer.MAX_VALUE);
        return importFinished.parallelStream().allMatch(this::isSizeConsistent);
    }

    private boolean isSizeConsistent(Event event) {
        TermFilterBuilder termFilterBuilder = FilterBuilders.termFilter((String)"@runId", (String)event.getTestRunId());
        long realCount = this.eventRepository.count((FilterBuilder)termFilterBuilder);
        long expectedCount = ((Integer)event.get("@size")).longValue();
        if (expectedCount == realCount) {
            return true;
        }
        LOG.warn("TestRun {} is inconsistent. It has size {}, while {} was expected", new Object[]{event.getTestRunId(), realCount, expectedCount});
        return false;
    }
}

