/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.google.common.base.Strings;
import com.xebialabs.deployit.repository.ItemConflictException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xltest.Synthetic;
import com.xebialabs.xltest.api.v1.dto.ProjectRequest;
import com.xebialabs.xltest.domain.Project;
import com.xebialabs.xltest.repository.ProjectRepository;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectService {
    private final ProjectRepository projectRepository;

    @Autowired
    public ProjectService(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    public Project createProject(ProjectRequest project) {
        String id = UUID.randomUUID().toString();
        Project newProject = Project.newProject(Synthetic.createProjectId(id));
        newProject.setTitle(project.getTitle());
        return this.projectRepository.createProject(newProject);
    }

    public List<Project> getProjects(String title) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!Strings.isNullOrEmpty((String)title)) {
            params.put("title", title);
        }
        return this.projectRepository.getProjects(params);
    }

    public Project getProject(String projectId) {
        this.projectRepository.validateProjectExists(projectId);
        return this.projectRepository.getProject(projectId);
    }

    public void deleteProject(String projectId, boolean force, String eTag) {
        if (eTag != null) {
            Project project = this.projectRepository.getProject(projectId);
            this.assertProjectIsFresh(project, eTag);
        }
        if (!force && !this.projectRepository.getTestSpecifications(projectId).isEmpty()) {
            throw new ItemInUseException("Project with id '%s' can not be deleted: it contains test specifications.", new Object[]{projectId});
        }
        this.projectRepository.delete(projectId, force);
    }

    public Project updateProject(String projectId, ProjectRequest projectRequest, String eTag) {
        this.projectRepository.validateProjectExists(projectId);
        Project project = this.projectRepository.getProject(projectId);
        this.assertProjectIsFresh(project, eTag);
        project.setTitle(projectRequest.getTitle());
        this.projectRepository.update(project);
        return this.getProject(projectId);
    }

    private void assertProjectIsFresh(Project project, String eTag) {
        if (eTag != null && !eTag.equals(project.get$token())) {
            throw new ItemConflictException("Project with id '%s' has been updated since you read it. Please reload the project.", new Object[]{project.getName()});
        }
    }
}

