/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.upgrade.jcr.v130;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameCITypesToFromXLTESTToXLTUpgrade
extends Upgrade {
    public Logger LOG = LoggerFactory.getLogger(RenameCITypesToFromXLTESTToXLTUpgrade.class);

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-testview", (String)"1.3.0#1");
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        List<String> types = Arrays.asList("ScriptedConfigurationItem", "Report", "Project", "Qualification", "BaseTestSpecification", "ActiveTestSpecification", "PassiveTestSpecification", "ExecutableTestSpecification", "ShowCaseTestSpecification", "TestSpecificationSet", "Dashboard", "DashboardTile");
        this.LOG.info("Renaming types from xltest. to xlt. for [{}]", types);
        for (String type : types) {
            String oldTypeName = "xltest." + type;
            String newTypeName = "xlt." + type;
            List nodesByType = repository.findNodesByType(Type.valueOf((String)oldTypeName));
            this.LOG.info("Renaming {} amount of {} to {} ", new Object[]{nodesByType.size(), oldTypeName, newTypeName});
            repository.renameType(oldTypeName, newTypeName);
        }
        return true;
    }
}

