/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.upgrade.jcr.v140;

import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.repository.EventRepositoryImpl;
import java.util.List;
import java.util.TreeSet;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ReplaceDotsInPerformanceResults
extends Upgrade {
    private static final Logger LOG = LoggerFactory.getLogger(ReplaceDotsInPerformanceResults.class);
    private final EventRepository eventRepository;
    private final int batchSize;

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-testview", (String)"1.4.0#3");
    }

    @Autowired
    public ReplaceDotsInPerformanceResults(EventRepository eventRepository, @Qualifier(value="xlt.upgrader.elasticsearch-batch-size") int batchSize) {
        this.eventRepository = eventRepository;
        this.batchSize = batchSize;
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        this.eventRepository.refreshIndex();
        List<Event> performanceResults = this.eventRepository.query("@type:performanceResult");
        if (!performanceResults.isEmpty()) {
            LOG.info("Found {} performance results upgrading...", (Object)performanceResults.size());
            ((EventRepositoryImpl)this.eventRepository).deleteMapping("performanceResult");
            this.eventRepository.refreshIndex();
            performanceResults.stream().forEach(this::changeDotToUnderscore);
            this.eventRepository.insert(performanceResults);
            this.eventRepository.refreshIndex();
            long eventsAfterUpgrade = -1L;
            for (int i = 0; i < 100; ++i) {
                eventsAfterUpgrade = this.eventRepository.count((FilterBuilder)FilterBuilders.termFilter((String)"@type", (String)"performanceResult"));
                if (eventsAfterUpgrade == (long)performanceResults.size()) {
                    return true;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new UpgradeException("Was not able to determine if performanceResults index upgraded properly", new Object[0]);
                }
            }
            throw new UpgradeException(String.format("Was not able to upgrade performance results. Updated %d, found %d in database after upgrade", performanceResults.size(), eventsAfterUpgrade), new Object[0]);
        }
        return true;
    }

    private void changeDotToUnderscore(Event event) {
        for (String key : new TreeSet(event.getProperties().keySet())) {
            if (!key.contains(".")) continue;
            this.replaceKey(event, key, key.replace('.', '_'));
        }
        event.remove("_id");
    }

    private void replaceKey(Event event, String oldKey, String newKey) {
        Object value = event.get(oldKey);
        if (value != null) {
            event.update(newKey, value);
            event.remove(oldKey);
        }
    }
}

