/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils.glob;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class FileMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(FileMatcher.class);
    public static final char ANT_PATTERN_SEPARATOR = ',';
    private final AntPathMatcher pathMatcher = new AntPathMatcher();
    private final List<String> patterns;

    public FileMatcher(String pattern) {
        Preconditions.checkNotNull((Object)pattern, (Object)"A Ant style pattern is required");
        this.patterns = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)pattern);
    }

    public boolean match(String filePath) {
        return this.patterns.stream().anyMatch(p -> this.pathMatcher.match(p, filePath));
    }

    public String toString() {
        return Joiner.on((char)',').join(this.patterns);
    }
}

