/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm;

import com.xebialabs.overthere.cifs.winrm.WsmanKerberosScheme;
import org.apache.http.auth.AuthScheme;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WsmanKerberosSchemeFactory
extends KerberosSchemeFactory {
    private final String spnServiceClass;
    private final String spnHost;
    private final int spnPort;
    private Logger logger = LoggerFactory.getLogger(WsmanKerberosSchemeFactory.class);

    public WsmanKerberosSchemeFactory(boolean stripPort, String spnServiceClass, String spnHost, int spnPort) {
        super(stripPort);
        this.spnServiceClass = spnServiceClass;
        this.spnHost = spnHost;
        this.spnPort = spnPort;
    }

    public AuthScheme newInstance(HttpParams params) {
        this.logger.trace("WsmanKerberosSchemeFactory.newInstance invoked for SPN {}/{} (spnPort = {}, stripPort = {})", new Object[]{this.spnServiceClass, this.spnHost, this.spnPort, this.isStripPort()});
        return new WsmanKerberosScheme(this.isStripPort(), this.spnServiceClass, this.spnHost, this.spnPort);
    }

    public AuthScheme create(HttpContext context) {
        this.logger.trace("WsmanKerberosSchemeFactory.create invoked for SPN {}/{} (spnPort = {}, stripPort = {})", new Object[]{this.spnServiceClass, this.spnHost, this.spnPort, this.isStripPort()});
        return new WsmanKerberosScheme(this.isStripPort(), this.spnServiceClass, this.spnHost, this.spnPort);
    }
}

