/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix.bsd.macosx;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.rzo.yajsw.Constants;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.os.AbstractService;
import org.rzo.yajsw.os.JavaHome;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.posix.PosixUtils;
import org.rzo.yajsw.os.posix.VelocityLog;
import org.rzo.yajsw.util.Utils;

public class MacOsXService
extends AbstractService
implements Constants {
    String _launchdDir;
    String _plistTemplate;
    String _plistFile;
    int _stopTimeout;
    String _plistName;
    String _execCmd;
    String _confFile;
    PosixUtils _utils = new PosixUtils();

    @Override
    public void init() {
        File f;
        if (this._name == null) {
            System.out.println("no name for daemon -> abort");
            return;
        }
        this._launchdDir = this._config.getString("wrapper.launchd.dir", this.getDefaultLaunchDir());
        File daemonDir = new File(this._launchdDir);
        if (!daemonDir.exists()) {
            System.out.println("No LaunchAgents directory found yet. Creating");
            daemonDir.mkdirs();
        }
        if (!daemonDir.isDirectory()) {
            System.out.println("Error " + this._launchdDir + " : is not a directory");
            return;
        }
        String wrapperJar = WrapperLoader.getWrapperJar().trim();
        String wrapperHome = ".";
        try {
            wrapperHome = new File(wrapperJar).getParentFile().getCanonicalPath();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String confFile = this._config.getString("wrapper.config");
        String confDir = null;
        if (confFile != null && (f = new File(confFile)).exists()) {
            try {
                confDir = f.getParentFile().getCanonicalPath();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (confDir == null) {
            confDir = wrapperHome + "/conf";
        }
        if (confFile == null) {
            System.out.println("no conf file found -> abort");
            return;
        }
        try {
            this._confFile = new File(confFile).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this._plistTemplate = this._config.getString("wrapper.launchd.template", wrapperHome + "/templates/launchd.plist.vm");
        File daemonTemplate = new File(this._plistTemplate);
        if (!daemonTemplate.exists() || !daemonTemplate.isFile()) {
            System.out.println("Error " + this._plistTemplate + " : template file not found");
            return;
        }
        File daemonScript = new File(daemonDir, "wrapper." + this.getName());
        if (daemonScript.exists()) {
            System.out.println(daemonScript.getAbsolutePath() + " already exists -> overwrite");
        }
        this._plistName = this.getPlistPrefix() + this._name;
        File plistFile = new File(this._launchdDir, this._plistName + ".plist");
        try {
            this._plistFile = plistFile.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JavaHome javaHome = OperatingSystem.instance().getJavaHome(this._config);
        String java = System.getProperty("java.home") + "/bin/java";
        try {
            java = new File(java).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String tmpDir = this._config.getString("wrapper.tmp.path", System.getProperty("jna_tmpdir", null));
        ArrayList<String> result = new ArrayList<String>();
        String opt = null;
        if (tmpDir != null) {
            opt = Utils.getDOption("jna_tmpdir", tmpDir);
            result.add(opt);
        }
        YajswConfigurationImpl config = (YajswConfigurationImpl)this._config;
        Iterator it = config.subset("wrapper").getKeys();
        while (it.hasNext()) {
            try {
                config.getProperty((String)it.next());
            }
            catch (Exception ex) {}
        }
        if (this._config.getBoolean("wrapper.save_interpolated", true)) {
            for (Map.Entry<String, String> e : config.getEnvLookupSet().entrySet()) {
                if (e.getKey().contains("password") || result.contains(opt = Utils.getDOption(e.getKey(), e.getValue()))) continue;
                result.add(opt);
            }
        }
        it = this._config.getKeys("wrapper.ntservice.additional");
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = this._config.getString(key);
            result.add(value);
        }
        String properties = StringUtils.join(result, (String)" ");
        this._execCmd = String.format("\"%1$s\" -Dwrapper.service=true -Dwrapper.visible=false %2$s -jar \"%3$s\" -c \"%4$s\"", java, properties, wrapperJar, this._confFile);
    }

    protected String getPlistPrefix() {
        return "wrapper.";
    }

    protected String getDefaultLaunchDir() {
        return System.getProperty("user.home") + "/Library/LaunchAgents";
    }

    @Override
    public boolean install() {
        if (this._plistFile == null) {
            System.out.println("Error : not initialized -> abort");
            return false;
        }
        try {
            File daemonTemplate = new File(this._plistTemplate);
            VelocityEngine ve = new VelocityEngine();
            ve.setProperty("resource.loader", (Object)"file");
            ve.setProperty("file.resource.loader.path", (Object)daemonTemplate.getParent());
            ve.setProperty("runtime.log.logsystem.class", (Object)VelocityLog.class.getCanonicalName());
            ve.init();
            Template t = ve.getTemplate(daemonTemplate.getName());
            VelocityContext context = new VelocityContext();
            context.put("name", (Object)this._plistName);
            context.put("command", this.splitCommandByWhitespace());
            context.put("autoStart", (Object)"AUTOMATIC".equals(this._config.getString("wrapper.ntservice.starttype", "AUTO_START")));
            FileWriter writer = new FileWriter(this._plistFile);
            t.merge((Context)context, (Writer)writer);
            writer.flush();
            writer.close();
            this.preload();
            System.out.println(this._utils.osCommand("launchctl load " + this._plistFile, 5000L));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        boolean result = this.isInstalled();
        for (int i = 0; !result && i < 10; ++i) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return result;
            }
            result = this.isInstalled();
        }
        return result;
    }

    protected void preload() {
    }

    private List<String> splitCommandByWhitespace() {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(this._execCmd);
        while (m.find()) {
            list.add(m.group(1).replace("\"", ""));
        }
        return list;
    }

    public boolean isInstalled() {
        String list = this._utils.osCommand("launchctl list", 5000L);
        return list.contains(this._plistName);
    }

    public boolean isRunning() {
        int pid = this.getPid();
        return pid > 0;
    }

    @Override
    public boolean start() {
        if (this.isRunning()) {
            System.out.println("already running");
            return true;
        }
        this._utils.osCommand("launchctl start " + this._plistName, 5000L);
        boolean result = this.isRunning();
        for (int i = 0; !result && i < 10; ++i) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return result;
            }
            result = this.isRunning();
        }
        return result;
    }

    @Override
    public boolean stop() {
        if (this.isRunning()) {
            this._utils.osCommand("launchctl stop " + this._plistName, 5000L);
            boolean result = !this.isRunning();
            for (int i = 0; !result && i < 10; ++i) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return result;
                }
                result = !this.isRunning();
            }
            return result;
        }
        return true;
    }

    @Override
    public boolean uninstall() {
        if (this.isRunning()) {
            this.stop();
        }
        this._utils.osCommand("launchctl unload " + this._plistFile, 5000L);
        new File(this._plistFile).delete();
        boolean result = this.isInstalled();
        for (int i = 0; result && i < 10; ++i) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return result;
            }
            result = this.isInstalled();
        }
        return !result;
    }

    @Override
    public int state() {
        int result = 0;
        if (this.isInstalled()) {
            result |= 1;
        }
        if (this.isRunning()) {
            result |= 2;
        }
        return result;
    }

    public int getPid() {
        try {
            String sp = String.format("^(\\d+).*\\s*%1$s$", this._plistName);
            Pattern p = Pattern.compile(sp, 8);
            String list = this._utils.osCommand("launchctl list", 5000L);
            Matcher m = p.matcher(list);
            m.find();
            int pid = Integer.parseInt(m.group(1));
            return pid;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this._utils.setLog(logger);
    }
}

