/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.script;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import io.netty.util.internal.logging.InternalLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.codehaus.groovy.control.CompilationFailedException;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.script.AbstractScript;
import org.rzo.yajsw.util.VFSUtils;
import org.rzo.yajsw.wrapper.WrappedJavaProcess;
import org.rzo.yajsw.wrapper.WrappedProcess;

public class GroovyScript
extends AbstractScript {
    public static Map context = Collections.synchronizedMap(new HashMap());
    final Binding binding;
    final InternalLogger _logger;
    volatile GroovyObject _script;
    final boolean _reload;
    final String _encoding;
    static GroovyClassLoader groovyClassLoader;

    public GroovyScript(String script, String id, WrappedProcess process, String[] args, int timeout, InternalLogger logger, String encoding, boolean reload, int maxConcInvocations) throws CompilationFailedException, IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(script, id, process, args, timeout, maxConcInvocations);
        this._reload = reload;
        this._encoding = encoding;
        this._script = this.getScriptInstance(script, encoding);
        this.binding = (Binding)this._script.invokeMethod("getBinding", null);
        this.binding.setVariable("args", (Object)args);
        this.binding.setVariable("callCount", (Object)0);
        this.binding.setVariable("context", (Object)context);
        this._logger = process != null && logger == null ? process.getInternalWrapperLogger() : logger;
        this.binding.setVariable("logger", (Object)this._logger);
    }

    private void setGroovyClasspath(GroovyClassLoader loader) {
        ArrayList cp = WrapperLoader.getGroovyClasspath();
        ListIterator it = cp.listIterator();
        while (it.hasNext()) {
            loader.addURL((URL)it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroovyObject getScriptInstance(String scriptFileName, String encoding) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        FileObject fileObject = VFSUtils.resolveFile(".", scriptFileName);
        FileName fileName = fileObject.getName();
        long lastModified = fileObject.getContent().getLastModifiedTime();
        String scriptName = StringUtils.removeEnd((String)fileName.getBaseName(), (String)("." + fileName.getExtension())) + "_" + lastModified;
        Class<GroovyScript> clazz = GroovyScript.class;
        synchronized (GroovyScript.class) {
            if (groovyClassLoader == null) {
                groovyClassLoader = new GroovyClassLoader(this.getClass().getClassLoader());
                this.setGroovyClasspath(groovyClassLoader);
            }
            try {
                Class<?> clazz2 = Class.forName(scriptName, true, (ClassLoader)groovyClassLoader);
                if (this._script == null) {
                    // ** MonitorExit[var8_7] (shouldn't be in output)
                    return (GroovyObject)clazz2.newInstance();
                }
                // ** MonitorExit[var8_7] (shouldn't be in output)
                return this._script;
            }
            catch (ClassNotFoundException e) {
                if (this._script != null) {
                    this.log("script changed -> reloading");
                }
                InputStream in = null;
                String scriptSrc = null;
                try {
                    in = fileObject.getContent().getInputStream();
                    scriptSrc = encoding == null ? IOUtils.toString((InputStream)in) : IOUtils.toString((InputStream)in, (String)encoding);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                // ** MonitorExit[var8_7] (shouldn't be in output)
                return (GroovyObject)groovyClassLoader.parseClass(scriptSrc, scriptName + ".groovy").newInstance();
            }
        }
    }

    @Override
    public synchronized Object execute(String line) {
        Object result = null;
        if (this._script == null) {
            System.out.println("cannot execute script " + this._name);
            return null;
        }
        if (this._reload) {
            GroovyObject script = null;
            try {
                script = this.getScriptInstance(this._name, this._encoding);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (script != null && this._script != script) {
                script.invokeMethod("setBinding", (Object)this.binding);
                this._script = script;
            }
        }
        this.binding.setVariable("id", (Object)this._id);
        if (this._process != null) {
            this.binding.setVariable("state", (Object)this._process.getStringState());
            this.binding.setVariable("count", (Object)this._process.getRestartCount());
            this.binding.setVariable("pid", (Object)this._process.getAppPid());
            this.binding.setVariable("exitCode", (Object)this._process.getExitCode());
            this.binding.setVariable("line", (Object)line);
            this.binding.setVariable("process", (Object)this._process);
        }
        try {
            result = this._script.invokeMethod("run", (Object)new Object[0]);
        }
        catch (Throwable e) {
            if (this._logger != null) {
                this._logger.info("execption in script " + this._name, e);
            }
            e.printStackTrace();
        }
        this.binding.setVariable("callCount", (Object)((Integer)this.binding.getVariable("callCount") + 1));
        return result;
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        WrappedJavaProcess w = new WrappedJavaProcess();
        w.getLocalConfiguration().setProperty("wrapper.config", (Object)"conf/wrapper.helloworld.conf");
        w.init();
        GroovyScript script = new GroovyScript("./scripts/timeCondition.gv", "id", w, new String[]{"11", "12"}, 0, null, null, false, 1);
        script.execute();
        script.execute();
        script = new GroovyScript("./scripts/fileCondition.gv", "id", w, new String[]{"anchor.lck"}, 0, null, null, false, 1);
        script.execute();
        script.execute();
        script = new GroovyScript("./scripts/snmpTrap.gv", "id", w, new String[]{"192.168.0.1", "1", "msg"}, 0, null, null, false, 1);
        script.execute();
    }

    @Override
    public Object execute() {
        return this.execute("");
    }

    @Override
    public void executeWithTimeout() {
        this.executeWithTimeout("");
    }

    @Override
    public void interrupt() {
        if (this._future != null) {
            this._future.cancel(true);
        }
    }

    @Override
    void log(String msg) {
        if (this._logger != null) {
            this._logger.info(msg);
        } else {
            System.out.println(msg);
        }
    }

    public Object invoke(String method, Object ... x) {
        Object result = null;
        try {
            result = this._script.invokeMethod(method, (Object)x);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

