/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class AnnotatedElementUtils {
    public static Set<String> getMetaAnnotationTypes(AnnotatedElement element, String annotationType) {
        final LinkedHashSet<String> types = new LinkedHashSet<String>();
        AnnotatedElementUtils.process(element, annotationType, false, new Processor<Object>(){

            @Override
            public Object process(Annotation annotation, int metaDepth) {
                if (metaDepth > 0) {
                    types.add(annotation.annotationType().getName());
                }
                return null;
            }

            @Override
            public void postProcess(Annotation annotation, Object result) {
            }
        });
        return types.isEmpty() ? null : types;
    }

    public static boolean hasMetaAnnotationTypes(AnnotatedElement element, String annotationType) {
        return Boolean.TRUE.equals(AnnotatedElementUtils.process(element, annotationType, false, new Processor<Boolean>(){

            @Override
            public Boolean process(Annotation annotation, int metaDepth) {
                if (metaDepth > 0) {
                    return Boolean.TRUE;
                }
                return null;
            }

            @Override
            public void postProcess(Annotation annotation, Boolean result) {
            }
        }));
    }

    public static boolean isAnnotated(AnnotatedElement element, String annotationType) {
        return Boolean.TRUE.equals(AnnotatedElementUtils.process(element, annotationType, false, new Processor<Boolean>(){

            @Override
            public Boolean process(Annotation annotation, int metaDepth) {
                return Boolean.TRUE;
            }

            @Override
            public void postProcess(Annotation annotation, Boolean result) {
            }
        }));
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement element, String annotationType) {
        return AnnotatedElementUtils.getAnnotationAttributes(element, annotationType, false, false);
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement element, String annotationType, final boolean classValuesAsString, final boolean nestedAnnotationsAsMap) {
        return AnnotatedElementUtils.process(element, annotationType, false, new Processor<AnnotationAttributes>(){

            @Override
            public AnnotationAttributes process(Annotation annotation, int metaDepth) {
                return AnnotationUtils.getAnnotationAttributes(annotation, classValuesAsString, nestedAnnotationsAsMap);
            }

            @Override
            public void postProcess(Annotation annotation, AnnotationAttributes result) {
                for (String key : result.keySet()) {
                    Object value;
                    if ("value".equals(key) || (value = AnnotationUtils.getValue(annotation, key)) == null) continue;
                    result.put(key, AnnotationUtils.adaptValue(value, classValuesAsString, nestedAnnotationsAsMap));
                }
            }
        });
    }

    public static MultiValueMap<String, Object> getAllAnnotationAttributes(AnnotatedElement element, String annotationType) {
        return AnnotatedElementUtils.getAllAnnotationAttributes(element, annotationType, false, false);
    }

    public static MultiValueMap<String, Object> getAllAnnotationAttributes(AnnotatedElement element, final String annotationType, final boolean classValuesAsString, final boolean nestedAnnotationsAsMap) {
        final LinkedMultiValueMap<String, Object> attributes = new LinkedMultiValueMap<String, Object>();
        AnnotatedElementUtils.process(element, annotationType, false, new Processor<Void>(){

            @Override
            public Void process(Annotation annotation, int metaDepth) {
                if (annotation.annotationType().getName().equals(annotationType)) {
                    for (Map.Entry entry : AnnotationUtils.getAnnotationAttributes(annotation, classValuesAsString, nestedAnnotationsAsMap).entrySet()) {
                        attributes.add(entry.getKey(), entry.getValue());
                    }
                }
                return null;
            }

            @Override
            public void postProcess(Annotation annotation, Void result) {
                for (String key : attributes.keySet()) {
                    Object value;
                    if ("value".equals(key) || (value = AnnotationUtils.getValue(annotation, key)) == null) continue;
                    attributes.add(key, value);
                }
            }
        });
        return attributes.isEmpty() ? null : attributes;
    }

    private static <T> T process(AnnotatedElement element, String annotationType, boolean traverseClassHierarchy, Processor<T> processor) {
        try {
            return AnnotatedElementUtils.doProcess(element, annotationType, traverseClassHierarchy, processor, new HashSet<AnnotatedElement>(), 0);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to introspect annotations: " + element, ex);
        }
    }

    private static <T> T doProcess(AnnotatedElement element, String annotationType, boolean traverseClassHierarchy, Processor<T> processor, Set<AnnotatedElement> visited, int metaDepth) {
        if (visited.add(element)) {
            T result;
            Class superclass;
            T result2;
            Annotation[] annotations;
            for (Annotation annotation : annotations = traverseClassHierarchy ? element.getDeclaredAnnotations() : element.getAnnotations()) {
                if (!annotation.annotationType().getName().equals(annotationType) && metaDepth <= 0) continue;
                result2 = processor.process(annotation, metaDepth);
                if (result2 != null) {
                    return result2;
                }
                result2 = AnnotatedElementUtils.doProcess(annotation.annotationType(), annotationType, traverseClassHierarchy, processor, visited, metaDepth + 1);
                if (result2 == null) continue;
                processor.postProcess(annotation, result2);
                return result2;
            }
            for (Annotation annotation : annotations) {
                if (AnnotationUtils.isInJavaLangAnnotationPackage(annotation) || (result2 = AnnotatedElementUtils.doProcess(annotation.annotationType(), annotationType, traverseClassHierarchy, processor, visited, metaDepth)) == null) continue;
                processor.postProcess(annotation, result2);
                return result2;
            }
            if (traverseClassHierarchy && element instanceof Class && (superclass = ((Class)element).getSuperclass()) != null && !superclass.equals(Object.class) && (result = AnnotatedElementUtils.doProcess(superclass, annotationType, true, processor, visited, metaDepth)) != null) {
                return result;
            }
        }
        return null;
    }

    private static interface Processor<T> {
        public T process(Annotation var1, int var2);

        public void postProcess(Annotation var1, T var2);
    }
}

