# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

from modules.hierarchy import *

prefixArray = get_prefix_array(query_parameters)

events = test_runs.getEventsForTestRun(test_run, {'@tags': tags})

can_drill_down_result = None

rotation = -45

passed = {}
failed = {}
other = {}

for ev in events:
    if is_functional_result(ev) and prefix_within_hierarchy(ev, prefixArray):
        node = next_node_in_hierarchy(ev, prefixArray)

        if can_drill_down_result == None:
            can_drill_down_result = can_drill_down(ev, prefixArray)

        if node is None:
            continue

        result = ev.get('@result')

        if result == 'PASSED':
            passed[node] = passed.get(node, 0) + 1
        elif result == 'OTHER':
            other[node] = other.get(node, 0) + 1
        else:
            failed[node] = failed.get(node, 0) + 1

categories = sorted(set(failed.keys() + passed.keys() + other.keys()))

# prevent ability to drill down over the edge
if can_drill_down_result == False:
    prefixArray = prefixArray[:-1]

def make_column_values(counts):
    return map(lambda category: counts.get(category, 0) > 0 and {'y': counts[category], 'params': {'prefix': ';'.join(prefixArray + [category])}} or {'y': 0}, categories)

# Rework our data for representation (to highcharts format)
passed = make_column_values(passed)
failed = make_column_values(failed)
other = make_column_values(other)

level = len(prefixArray)
if level == 0:
    title = 'Passed versus failed tests from latest test run in time window'
else:
    title = 'Passed versus failed tests from latest test run in time window at level %s' % level

def count_vals(results):
    return reduce(lambda x, y: x + y, map(lambda r: r['y'], results), 0)

result_holder.result = {
        'chart': {
            'type': 'column'
        },
        'title': title,
        'description': 'This report presents the tests that passed and failed during the last execution of the test specification.',
        'xAxis': {
            'categories': categories,
            'labels': {
                'rotation': rotation,
            }
        },
        'yAxis': {
            'min': 0,
            'title': {
                'text': 'Number of tests',
                'style': {
                    'color': '#666',
                    'font-weight': 'normal'
                }
            },
            'minTickInterval': 1
        },
        'legend': {
            'borderColor': None,
            'symbolHeight': 16,
            'symbolWidth': 16
        },
        'plotOptions': {
            'column': {
                'animation': False,
                'cursor': 'pointer',
                'borderRadius': 2,
                'groupPadding': 0.1,
                'pointPadding': 0.01
            },
            'series':  {
               'point': {
                   'events': {
                       'click': 'url'
                   }
               }
           } or None
        },
        'series': [{
            'name': "Passed ({0})".format(count_vals(passed)),
            'data': passed
        }, {
            'name': "Failed ({0})".format(count_vals(failed)),
            'data': failed
        }, {
            'name': "Other ({0})".format(count_vals(other)),
            'data': other
        }]
    }

