/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.ExtensionLogger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.RepositoryI18n;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.text.TextExtractor;
import org.modeshape.jcr.text.TextExtractorOutput;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.InMemoryBinaryValue;

@Immutable
public final class TextExtractors {
    private static final Logger LOGGER = Logger.getLogger(TextExtractors.class);
    private final List<TextExtractor> extractors;
    private final ExecutorService extractingQueue;
    private final List<Future<?>> extractionResults;
    private final ConcurrentHashMap<BinaryKey, CountDownLatch> workerLatches;
    private volatile boolean active;

    public TextExtractors(ExecutorService extractingQueue, List<TextExtractor> extractors) {
        this.extractingQueue = extractingQueue;
        this.workerLatches = new ConcurrentHashMap();
        this.extractionResults = new ArrayList();
        this.extractors = extractors;
        this.active = true;
    }

    protected TextExtractors(JcrRepository.RunningState repository, RepositoryConfiguration.TextExtraction extracting) {
        this(repository.context().getCachedTreadPool(extracting.getThreadPoolName(), extracting.getMaxPoolSize()), TextExtractors.getConfiguredExtractors(repository, extracting));
    }

    protected void shutdown() {
        this.active = false;
        this.extractors.clear();
        this.extractingQueue.shutdown();
        for (Future<?> extractionResult : this.extractionResults) {
            extractionResult.cancel(true);
        }
        this.extractionResults.clear();
    }

    public boolean extractionEnabled() {
        return this.active && !this.extractors.isEmpty();
    }

    public String extract(InMemoryBinaryValue inMemoryBinaryValue, TextExtractor.Context context) {
        if (!this.extractionEnabled()) {
            return null;
        }
        try {
            String mimeType = inMemoryBinaryValue.getMimeType();
            TextExtractorOutput output = new TextExtractorOutput();
            for (TextExtractor extractor : this.extractors) {
                if (!extractor.supportsMimeType(mimeType)) continue;
                extractor.extractFrom((Binary)inMemoryBinaryValue, (TextExtractor.Output)output, context);
                break;
            }
            return output.getText();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, (I18nResource)JcrI18n.errorExtractingTextFromBinary, new Object[]{inMemoryBinaryValue.getHexHash(), e.getLocalizedMessage()});
            return null;
        }
    }

    public CountDownLatch extract(AbstractBinaryStore store, BinaryValue binaryValue, TextExtractor.Context context) {
        if (!this.extractionEnabled()) {
            return null;
        }
        if (binaryValue instanceof InMemoryBinaryValue) {
            return null;
        }
        CheckArg.isNotNull((Object)binaryValue, (String)"binaryValue");
        CountDownLatch latch = this.getWorkerLatch(binaryValue.getKey(), true);
        this.extractionResults.add(this.extractingQueue.submit(new Worker(store, binaryValue, context, latch)));
        return latch;
    }

    public CountDownLatch getWorkerLatch(BinaryKey binaryKey, boolean createIfMissing) {
        if (createIfMissing) {
            CountDownLatch latch = new CountDownLatch(1);
            CountDownLatch existingLatch = this.workerLatches.putIfAbsent(binaryKey, latch);
            return existingLatch != null ? existingLatch : latch;
        }
        return this.workerLatches.get(binaryKey);
    }

    private static List<TextExtractor> getConfiguredExtractors(JcrRepository.RunningState repository, RepositoryConfiguration.TextExtraction extracting) {
        List<RepositoryConfiguration.Component> extractorComponents = extracting.getTextExtractors(repository.problems());
        ArrayList<TextExtractor> extractors = new ArrayList<TextExtractor>(extractorComponents.size());
        for (RepositoryConfiguration.Component component : extractorComponents) {
            try {
                TextExtractor extractor = (TextExtractor)component.createInstance(TextExtractors.class.getClassLoader());
                extractor.setLogger(ExtensionLogger.getLogger(extractor.getClass()));
                extractors.add(extractor);
            }
            catch (Throwable t) {
                String desc = component.getName();
                String repoName = repository.name();
                repository.error(t, JcrI18n.unableToInitializeTextExtractor, desc, repoName, t.getMessage());
            }
        }
        return extractors;
    }

    protected final class Worker
    implements Runnable {
        private final BinaryValue binaryValue;
        private final TextExtractor.Context context;
        private final AbstractBinaryStore store;
        private final CountDownLatch latch;

        protected Worker(AbstractBinaryStore store, BinaryValue binaryValue, TextExtractor.Context context, CountDownLatch latch) {
            this.store = store;
            this.binaryValue = binaryValue;
            this.context = context;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!TextExtractors.this.active) {
                return;
            }
            try {
                String extractedText;
                if (this.store.getExtractedText(this.binaryValue) != null) {
                    return;
                }
                String mimeType = this.binaryValue.getMimeType();
                TextExtractorOutput output = new TextExtractorOutput();
                for (TextExtractor extractor : TextExtractors.this.extractors) {
                    if (!extractor.supportsMimeType(mimeType)) continue;
                    extractor.extractFrom((Binary)this.binaryValue, (TextExtractor.Output)output, this.context);
                    break;
                }
                if ((extractedText = output.getText()) != null && !StringUtil.isBlank((String)extractedText)) {
                    this.store.storeExtractedText(this.binaryValue, extractedText);
                }
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                LOGGER.warn((I18nResource)RepositoryI18n.shutdownWhileExtractingText, new Object[]{this.binaryValue.getKey(), ie.getMessage()});
            }
            catch (Throwable t) {
                if (!TextExtractors.this.active) {
                    LOGGER.warn((I18nResource)RepositoryI18n.shutdownWhileExtractingText, new Object[]{this.binaryValue.getKey(), t.getMessage()});
                } else {
                    LOGGER.error(t, (I18nResource)JcrI18n.errorExtractingTextFromBinary, new Object[]{this.binaryValue.getHexHash(), t.getLocalizedMessage()});
                }
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

