/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.parse;

import org.infinispan.schematic.internal.HashCode;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.Position;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.jcr.query.model.SelectorName;

@Immutable
class ColumnExpression {
    private final SelectorName selectorName;
    private final String propertyName;
    private final String columnName;
    private final Position position;

    ColumnExpression(SelectorName selectorName, String propertyName, String columnName, Position position) {
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        CheckArg.isNotNull((Object)columnName, (String)"columnName");
        CheckArg.isNotNull((Object)position, (String)"position");
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.columnName = columnName;
        this.position = position;
    }

    public Position getPosition() {
        return this.position;
    }

    public final SelectorName getSelectorName() {
        return this.selectorName;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.selectorName, this.propertyName, this.columnName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ColumnExpression) {
            ColumnExpression that = (ColumnExpression)obj;
            if (!ObjectUtil.isEqualWithNulls((Object)this.selectorName, (Object)that.selectorName)) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls((Object)this.propertyName, (Object)that.propertyName)) {
                return false;
            }
            return ObjectUtil.isEqualWithNulls((Object)this.columnName, (Object)that.columnName);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.selectorName != null) {
            sb.append(this.selectorName.name());
            sb.append('.');
        }
        sb.append(this.propertyName);
        if (this.columnName != null) {
            sb.append(" AS ").append(this.columnName);
        }
        return sb.toString();
    }
}

