/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import org.modeshape.common.text.TextDecoder;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ReferenceFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.basic.NodeKeyReference;
import org.modeshape.jcr.value.basic.ReferenceValueFactory;

public class NodeIdentifierReferenceFactory
extends ReferenceValueFactory {
    private final NodeKey rootKey;

    public static NodeIdentifierReferenceFactory newInstance(NodeKey rootKey, TextDecoder decoder, ValueFactories factories, boolean weak, boolean simple) {
        if (simple) {
            return new NodeIdentifierReferenceFactory(PropertyType.SIMPLEREFERENCE, decoder, factories, weak, simple, rootKey);
        }
        return new NodeIdentifierReferenceFactory(weak ? PropertyType.WEAKREFERENCE : PropertyType.REFERENCE, decoder, factories, weak, simple, rootKey);
    }

    protected NodeIdentifierReferenceFactory(PropertyType type, TextDecoder decoder, ValueFactories valueFactories, boolean weak, boolean simple, NodeKey rootKey) {
        super(type, decoder, valueFactories, weak, simple);
        this.rootKey = rootKey;
    }

    @Override
    public Reference create(String value) {
        if (value == null) {
            return null;
        }
        NodeKey key = JcrSession.createNodeKeyFromIdentifier(value, this.rootKey);
        boolean isForeign = !key.getSourceKey().equals(this.rootKey.getSourceKey()) || !key.getWorkspaceKey().equals(this.rootKey.getWorkspaceKey());
        return new NodeKeyReference(key, this.weak, isForeign, this.simple);
    }

    @Override
    public ReferenceFactory with(ValueFactories valueFactories) {
        return valueFactories == this.valueFactories ? this : new NodeIdentifierReferenceFactory(super.getPropertyType(), this.decoder, valueFactories, this.weak, this.simple, this.rootKey);
    }
}

