/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.spring;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.jboss.resteasy.plugins.spring.SpringContextLoader;
import org.jboss.resteasy.plugins.spring.SpringContextLoaderSupport;
import org.jboss.resteasy.plugins.spring.i18n.Messages;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;

public class SpringContextLoaderListener
extends ContextLoaderListener {
    private SpringContextLoaderSupport springContextLoaderSupport = new SpringContextLoaderSupport();

    public void contextInitialized(ServletContextEvent event) {
        String sResources;
        String scanAll;
        boolean scanProviders = false;
        boolean scanResources = false;
        String sProviders = event.getServletContext().getInitParameter("resteasy.scan.providers");
        if (sProviders != null) {
            scanProviders = Boolean.valueOf(sProviders.trim());
        }
        if ((scanAll = event.getServletContext().getInitParameter("resteasy.scan")) != null) {
            boolean tmp = Boolean.valueOf(scanAll.trim());
            scanProviders = tmp || scanProviders;
            boolean bl = scanResources = tmp || scanResources;
        }
        if ((sResources = event.getServletContext().getInitParameter("resteasy.scan.resources")) != null) {
            scanResources = Boolean.valueOf(sResources.trim());
        }
        if (scanProviders || scanResources) {
            throw new RuntimeException(Messages.MESSAGES.cannotUseScanParameters());
        }
        super.contextInitialized(event);
    }

    protected ContextLoader createContextLoader() {
        return new SpringContextLoader();
    }

    protected void customizeContext(ServletContext servletContext, ConfigurableWebApplicationContext configurableWebApplicationContext) {
        super.customizeContext(servletContext, configurableWebApplicationContext);
        this.springContextLoaderSupport.customizeContext(servletContext, configurableWebApplicationContext);
    }
}

