/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.SingleTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.PrefixTermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.automaton.UTF32ToUTF8;

public class CompiledAutomaton {
    public final AUTOMATON_TYPE type;
    public final BytesRef term;
    public final ByteRunAutomaton runAutomaton;
    public final Automaton automaton;
    public final BytesRef commonSuffixRef;
    public final Boolean finite;
    private Transition transition = new Transition();

    public CompiledAutomaton(Automaton automaton) {
        this(automaton, null, true);
    }

    public CompiledAutomaton(Automaton automaton, Boolean finite, boolean simplify) {
        this(automaton, finite, simplify, 10000);
    }

    public CompiledAutomaton(Automaton automaton, Boolean finite, boolean simplify, int maxDeterminizedStates) {
        if (automaton.getNumStates() == 0) {
            automaton = new Automaton();
            automaton.createState();
        }
        if (simplify) {
            if (Operations.isEmpty(automaton)) {
                this.type = AUTOMATON_TYPE.NONE;
                this.term = null;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = null;
                return;
            }
            if (Operations.isTotal(automaton)) {
                this.type = AUTOMATON_TYPE.ALL;
                this.term = null;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = null;
                return;
            }
            String commonPrefix = Operations.getCommonPrefix(automaton = Operations.determinize(automaton, maxDeterminizedStates));
            String singleton = commonPrefix.length() > 0 && Operations.sameLanguage(automaton, Automata.makeString(commonPrefix)) ? commonPrefix : null;
            if (singleton != null) {
                this.type = AUTOMATON_TYPE.SINGLE;
                this.term = new BytesRef(singleton);
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = null;
                return;
            }
            if (commonPrefix.length() > 0) {
                Automaton other = Operations.concatenate(Automata.makeString(commonPrefix), Automata.makeAnyString());
                other = Operations.determinize(other, maxDeterminizedStates);
                assert (!Operations.hasDeadStates(other));
                if (Operations.sameLanguage(automaton, other)) {
                    this.type = AUTOMATON_TYPE.PREFIX;
                    this.term = new BytesRef(commonPrefix);
                    this.commonSuffixRef = null;
                    this.runAutomaton = null;
                    this.automaton = null;
                    this.finite = null;
                    return;
                }
            }
        }
        this.type = AUTOMATON_TYPE.NORMAL;
        this.term = null;
        this.finite = finite == null ? Boolean.valueOf(Operations.isFinite(automaton)) : finite;
        Automaton utf8 = new UTF32ToUTF8().convert(automaton);
        this.commonSuffixRef = this.finite != false ? null : Operations.getCommonSuffixBytesRef(utf8, maxDeterminizedStates);
        this.runAutomaton = new ByteRunAutomaton(utf8, true, maxDeterminizedStates);
        this.automaton = this.runAutomaton.automaton;
    }

    private BytesRef addTail(int state, BytesRefBuilder term, int idx, int leadLabel) {
        int maxIndex = -1;
        int numTransitions = this.automaton.initTransition(state, this.transition);
        int i = 0;
        while (i < numTransitions) {
            this.automaton.getNextTransition(this.transition);
            if (this.transition.min >= leadLabel) break;
            maxIndex = i++;
        }
        assert (maxIndex != -1);
        this.automaton.getTransition(state, maxIndex, this.transition);
        int floorLabel = this.transition.max > leadLabel - 1 ? leadLabel - 1 : this.transition.max;
        term.grow(1 + idx);
        term.setByteAt(idx, (byte)floorLabel);
        state = this.transition.dest;
        ++idx;
        while (true) {
            if ((numTransitions = this.automaton.getNumTransitions(state)) == 0) {
                assert (this.runAutomaton.isAccept(state));
                term.setLength(idx);
                return term.get();
            }
            this.automaton.getTransition(state, numTransitions - 1, this.transition);
            term.grow(1 + idx);
            term.setByteAt(idx, (byte)this.transition.max);
            state = this.transition.dest;
            ++idx;
        }
    }

    public TermsEnum getTermsEnum(Terms terms) throws IOException {
        switch (this.type) {
            case NONE: {
                return TermsEnum.EMPTY;
            }
            case ALL: {
                return terms.iterator(null);
            }
            case SINGLE: {
                return new SingleTermsEnum(terms.iterator(null), this.term);
            }
            case PREFIX: {
                return new PrefixTermsEnum(terms.iterator(null), this.term);
            }
            case NORMAL: {
                return terms.intersect(this, null);
            }
        }
        throw new RuntimeException("unhandled case");
    }

    public BytesRef floor(BytesRef input, BytesRefBuilder output) {
        int state = this.runAutomaton.getInitialState();
        if (input.length == 0) {
            if (this.runAutomaton.isAccept(state)) {
                output.clear();
                return output.get();
            }
            return null;
        }
        ArrayList<Integer> stack = new ArrayList<Integer>();
        int idx = 0;
        while (true) {
            int label = input.bytes[input.offset + idx] & 0xFF;
            int nextState = this.runAutomaton.step(state, label);
            if (idx == input.length - 1) {
                if (nextState != -1 && this.runAutomaton.isAccept(nextState)) {
                    output.grow(1 + idx);
                    output.setByteAt(idx, (byte)label);
                    output.setLength(input.length);
                    return output.get();
                }
                nextState = -1;
            }
            if (nextState == -1) {
                while (true) {
                    int numTransitions;
                    if ((numTransitions = this.automaton.getNumTransitions(state)) == 0) {
                        assert (this.runAutomaton.isAccept(state));
                        output.setLength(idx);
                        return output.get();
                    }
                    this.automaton.getTransition(state, 0, this.transition);
                    if (label - 1 >= this.transition.min) break;
                    if (this.runAutomaton.isAccept(state)) {
                        output.setLength(idx);
                        return output.get();
                    }
                    if (stack.size() == 0) {
                        return null;
                    }
                    state = (Integer)stack.remove(stack.size() - 1);
                    label = input.bytes[input.offset + --idx] & 0xFF;
                }
                return this.addTail(state, output, idx, label);
            }
            output.grow(1 + idx);
            output.setByteAt(idx, (byte)label);
            stack.add(state);
            state = nextState;
            ++idx;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.runAutomaton == null ? 0 : this.runAutomaton.hashCode());
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompiledAutomaton other = (CompiledAutomaton)obj;
        if (this.type != other.type) {
            return false;
        }
        return !(this.type == AUTOMATON_TYPE.SINGLE || this.type == AUTOMATON_TYPE.PREFIX ? !this.term.equals(other.term) : this.type == AUTOMATON_TYPE.NORMAL && !this.runAutomaton.equals(other.runAutomaton));
    }

    public static enum AUTOMATON_TYPE {
        NONE,
        ALL,
        SINGLE,
        PREFIX,
        NORMAL;

    }
}

