/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles2;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesException;
import org.apache.tiles.awareness.TilesApplicationContextAware;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.DefinitionsReader;
import org.apache.tiles.definition.Refreshable;
import org.apache.tiles.definition.dao.BaseLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.dao.CachingLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.digester.DigesterDefinitionsReader;
import org.apache.tiles.el.ELAttributeEvaluator;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.evaluator.BasicAttributeEvaluatorFactory;
import org.apache.tiles.evaluator.impl.DirectAttributeEvaluator;
import org.apache.tiles.extras.complete.CompleteAutoloadTilesContainerFactory;
import org.apache.tiles.extras.complete.CompleteAutoloadTilesInitializer;
import org.apache.tiles.factory.AbstractTilesContainerFactory;
import org.apache.tiles.factory.BasicTilesContainerFactory;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.impl.mgmt.CachingTilesContainer;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.preparer.PreparerFactory;
import org.apache.tiles.startup.AbstractTilesInitializer;
import org.apache.tiles.startup.TilesInitializer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.view.tiles2.SpringLocaleResolver;
import org.springframework.web.servlet.view.tiles2.SpringWildcardServletTilesApplicationContext;

public class TilesConfigurer
implements ServletContextAware,
InitializingBean,
DisposableBean {
    private static final boolean tilesElPresent = ClassUtils.isPresent((String)"org.apache.tiles.el.ELAttributeEvaluator", (ClassLoader)TilesConfigurer.class.getClassLoader());
    protected final Log logger = LogFactory.getLog(this.getClass());
    private TilesInitializer tilesInitializer;
    private String[] definitions;
    private boolean checkRefresh = false;
    private boolean validateDefinitions = true;
    private Class<? extends DefinitionsFactory> definitionsFactoryClass;
    private Class<? extends PreparerFactory> preparerFactoryClass;
    private boolean useMutableTilesContainer = false;
    private ServletContext servletContext;

    public void setTilesInitializer(TilesInitializer tilesInitializer) {
        this.tilesInitializer = tilesInitializer;
    }

    public void setCompleteAutoload(boolean completeAutoload) {
        if (completeAutoload) {
            try {
                this.tilesInitializer = new SpringCompleteAutoloadTilesInitializer();
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Tiles-Extras 2.2 not available", ex);
            }
        } else {
            this.tilesInitializer = null;
        }
    }

    public void setDefinitions(String ... definitions) {
        this.definitions = definitions;
    }

    public void setCheckRefresh(boolean checkRefresh) {
        this.checkRefresh = checkRefresh;
    }

    public void setValidateDefinitions(boolean validateDefinitions) {
        this.validateDefinitions = validateDefinitions;
    }

    public void setDefinitionsFactoryClass(Class<? extends DefinitionsFactory> definitionsFactoryClass) {
        this.definitionsFactoryClass = definitionsFactoryClass;
    }

    public void setPreparerFactoryClass(Class<? extends PreparerFactory> preparerFactoryClass) {
        this.preparerFactoryClass = preparerFactoryClass;
    }

    public void setUseMutableTilesContainer(boolean useMutableTilesContainer) {
        this.useMutableTilesContainer = useMutableTilesContainer;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void afterPropertiesSet() throws TilesException {
        SpringWildcardServletTilesApplicationContext preliminaryContext = new SpringWildcardServletTilesApplicationContext(this.servletContext);
        if (this.tilesInitializer == null) {
            this.tilesInitializer = this.createTilesInitializer();
        }
        this.tilesInitializer.initialize((TilesApplicationContext)preliminaryContext);
    }

    protected TilesInitializer createTilesInitializer() {
        return new SpringTilesInitializer();
    }

    public void destroy() throws TilesException {
        this.tilesInitializer.destroy();
    }

    private static class TilesElActivator {
        private TilesElActivator() {
        }

        public static AttributeEvaluator createEvaluator(TilesApplicationContext applicationContext) {
            ELAttributeEvaluator evaluator = new ELAttributeEvaluator();
            evaluator.setApplicationContext(applicationContext);
            evaluator.init(Collections.emptyMap());
            return evaluator;
        }
    }

    private static class SpringCompleteAutoloadTilesContainerFactory
    extends CompleteAutoloadTilesContainerFactory {
        private SpringCompleteAutoloadTilesContainerFactory() {
        }

        protected LocaleResolver createLocaleResolver(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
            return new SpringLocaleResolver();
        }
    }

    private static class SpringCompleteAutoloadTilesInitializer
    extends CompleteAutoloadTilesInitializer {
        private SpringCompleteAutoloadTilesInitializer() {
        }

        protected AbstractTilesContainerFactory createContainerFactory(TilesApplicationContext context) {
            return new SpringCompleteAutoloadTilesContainerFactory();
        }
    }

    private class SpringTilesContainerFactory
    extends BasicTilesContainerFactory {
        private SpringTilesContainerFactory() {
        }

        protected BasicTilesContainer instantiateContainer(TilesApplicationContext context) {
            return TilesConfigurer.this.useMutableTilesContainer ? new CachingTilesContainer() : new BasicTilesContainer();
        }

        protected void registerRequestContextFactory(String className, List<TilesRequestContextFactory> factories, TilesRequestContextFactory parent) {
            if (ClassUtils.isPresent((String)className, (ClassLoader)TilesConfigurer.class.getClassLoader())) {
                super.registerRequestContextFactory(className, factories, parent);
            }
        }

        protected List<URL> getSourceURLs(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
            if (TilesConfigurer.this.definitions != null) {
                try {
                    LinkedList<URL> result = new LinkedList<URL>();
                    for (String definition : TilesConfigurer.this.definitions) {
                        Set resources = applicationContext.getResources(definition);
                        if (resources == null) continue;
                        result.addAll(resources);
                    }
                    return result;
                }
                catch (IOException ex) {
                    throw new DefinitionsFactoryException("Cannot load definition URLs", (Exception)ex);
                }
            }
            return super.getSourceURLs(applicationContext, contextFactory);
        }

        protected BaseLocaleUrlDefinitionDAO instantiateLocaleDefinitionDao(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
            BaseLocaleUrlDefinitionDAO dao = super.instantiateLocaleDefinitionDao(applicationContext, contextFactory, resolver);
            if (TilesConfigurer.this.checkRefresh && dao instanceof CachingLocaleUrlDefinitionDAO) {
                ((CachingLocaleUrlDefinitionDAO)dao).setCheckRefresh(true);
            }
            return dao;
        }

        protected DefinitionsReader createDefinitionsReader(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
            DigesterDefinitionsReader reader = new DigesterDefinitionsReader();
            if (!TilesConfigurer.this.validateDefinitions) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("org.apache.tiles.definition.digester.DigesterDefinitionsReader.PARSER_VALIDATE", Boolean.FALSE.toString());
                reader.init(map);
            }
            return reader;
        }

        protected DefinitionsFactory createDefinitionsFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
            if (TilesConfigurer.this.definitionsFactoryClass != null) {
                BeanWrapper bw;
                DefinitionsFactory factory = (DefinitionsFactory)BeanUtils.instantiate((Class)TilesConfigurer.this.definitionsFactoryClass);
                if (factory instanceof TilesApplicationContextAware) {
                    ((TilesApplicationContextAware)factory).setApplicationContext(applicationContext);
                }
                if ((bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)factory)).isWritableProperty("localeResolver")) {
                    bw.setPropertyValue("localeResolver", (Object)resolver);
                }
                if (bw.isWritableProperty("definitionDAO")) {
                    bw.setPropertyValue("definitionDAO", (Object)this.createLocaleDefinitionDao(applicationContext, contextFactory, resolver));
                }
                if (factory instanceof Refreshable) {
                    ((Refreshable)factory).refresh();
                }
                return factory;
            }
            return super.createDefinitionsFactory(applicationContext, contextFactory, resolver);
        }

        protected PreparerFactory createPreparerFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
            if (TilesConfigurer.this.preparerFactoryClass != null) {
                return (PreparerFactory)BeanUtils.instantiate((Class)TilesConfigurer.this.preparerFactoryClass);
            }
            return super.createPreparerFactory(applicationContext, contextFactory);
        }

        protected LocaleResolver createLocaleResolver(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
            return new SpringLocaleResolver();
        }

        protected AttributeEvaluatorFactory createAttributeEvaluatorFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
            Object evaluator = tilesElPresent && JspFactory.getDefaultFactory() != null ? TilesElActivator.createEvaluator(applicationContext) : new DirectAttributeEvaluator();
            return new BasicAttributeEvaluatorFactory((AttributeEvaluator)evaluator);
        }
    }

    private class SpringTilesInitializer
    extends AbstractTilesInitializer {
        private SpringTilesInitializer() {
        }

        protected AbstractTilesContainerFactory createContainerFactory(TilesApplicationContext context) {
            return new SpringTilesContainerFactory();
        }
    }
}

