/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.os.OsStats;

public class OsService
extends AbstractComponent {
    private final OsProbe probe;
    private final OsInfo info;
    private SingleObjectCache<OsStats> osStatsCache;

    @Inject
    public OsService(Settings settings, OsProbe probe) {
        super(settings);
        this.probe = probe;
        TimeValue refreshInterval = settings.getAsTime("monitor.os.refresh_interval", TimeValue.timeValueSeconds(1L));
        this.info = probe.osInfo();
        this.info.refreshInterval = refreshInterval.millis();
        this.info.availableProcessors = Runtime.getRuntime().availableProcessors();
        this.osStatsCache = new OsStatsCache(refreshInterval, probe.osStats());
        this.logger.debug("Using probe [{}] with refresh_interval [{}]", probe, refreshInterval);
    }

    public OsInfo info() {
        return this.info;
    }

    public synchronized OsStats stats() {
        return this.osStatsCache.getOrRefresh();
    }

    private class OsStatsCache
    extends SingleObjectCache<OsStats> {
        public OsStatsCache(TimeValue interval, OsStats initValue) {
            super(interval, initValue);
        }

        @Override
        protected OsStats refresh() {
            return OsService.this.probe.osStats();
        }
    }
}

