/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptParameterParser;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicStreams;

public class ScriptHeuristic
extends SignificanceHeuristic {
    protected static final ParseField NAMES_FIELD = new ParseField("script_heuristic", new String[0]);
    private final LongAccessor subsetSizeHolder = new LongAccessor();
    private final LongAccessor supersetSizeHolder = new LongAccessor();
    private final LongAccessor subsetDfHolder = new LongAccessor();
    private final LongAccessor supersetDfHolder = new LongAccessor();
    ExecutableScript script = null;
    String scriptLang;
    String scriptString;
    ScriptService.ScriptType scriptType;
    Map<String, Object> params;
    public static final SignificanceHeuristicStreams.Stream STREAM = new SignificanceHeuristicStreams.Stream(){

        @Override
        public SignificanceHeuristic readResult(StreamInput in) throws IOException {
            return new ScriptHeuristic(null, in.readOptionalString(), in.readString(), ScriptService.ScriptType.readFrom(in), in.readMap());
        }

        @Override
        public String getName() {
            return NAMES_FIELD.getPreferredName();
        }
    };

    public ScriptHeuristic(ExecutableScript searchScript, String scriptLang, String scriptString, ScriptService.ScriptType scriptType, Map<String, Object> params) {
        this.script = searchScript;
        if (this.script != null) {
            this.script.setNextVar("_subset_freq", this.subsetDfHolder);
            this.script.setNextVar("_subset_size", this.subsetSizeHolder);
            this.script.setNextVar("_superset_freq", this.supersetDfHolder);
            this.script.setNextVar("_superset_size", this.supersetSizeHolder);
        }
        this.scriptLang = scriptLang;
        this.scriptString = scriptString;
        this.scriptType = scriptType;
        this.params = params;
    }

    @Override
    public void initialize(InternalAggregation.ReduceContext context) {
        this.script = context.scriptService().executable(this.scriptLang, this.scriptString, this.scriptType, ScriptContext.Standard.AGGS, this.params);
        this.script.setNextVar("_subset_freq", this.subsetDfHolder);
        this.script.setNextVar("_subset_size", this.subsetSizeHolder);
        this.script.setNextVar("_superset_freq", this.supersetDfHolder);
        this.script.setNextVar("_superset_size", this.supersetSizeHolder);
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        if (this.script == null) {
            ESLoggerFactory.getLogger("script heuristic").warn("cannot compute score - script has not been initialized yet.", new Object[0]);
            return 0.0;
        }
        this.subsetSizeHolder.value = subsetSize;
        this.supersetSizeHolder.value = supersetSize;
        this.subsetDfHolder.value = subsetFreq;
        this.supersetDfHolder.value = supersetFreq;
        return ((Number)this.script.run()).doubleValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(STREAM.getName());
        out.writeOptionalString(this.scriptLang);
        out.writeString(this.scriptString);
        ScriptService.ScriptType.writeTo(this.scriptType, out);
        out.writeMap(this.params);
    }

    public final class LongAccessor
    extends Number {
        public long value;

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }

    public static class ScriptHeuristicBuilder
    implements SignificanceHeuristicBuilder {
        private String script = null;
        private String lang = null;
        private Map<String, Object> params = null;
        private String scriptId;
        private String scriptFile;

        public ScriptHeuristicBuilder setScript(String script) {
            this.script = script;
            return this;
        }

        public ScriptHeuristicBuilder setScriptFile(String script) {
            this.scriptFile = script;
            return this;
        }

        public ScriptHeuristicBuilder setLang(String lang) {
            this.lang = lang;
            return this;
        }

        public ScriptHeuristicBuilder setParams(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public ScriptHeuristicBuilder setScriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        @Override
        public void toXContent(XContentBuilder builder) throws IOException {
            builder.startObject(STREAM.getName());
            if (this.script != null) {
                builder.field("script", this.script);
            }
            if (this.lang != null) {
                builder.field("lang", this.lang);
            }
            if (this.params != null) {
                builder.field("params", this.params);
            }
            if (this.scriptId != null) {
                builder.field("script_id", this.scriptId);
            }
            if (this.scriptFile != null) {
                builder.field("script_file", this.scriptFile);
            }
            builder.endObject();
        }
    }

    public static class ScriptHeuristicParser
    implements SignificanceHeuristicParser {
        private final ScriptService scriptService;

        @Inject
        public ScriptHeuristicParser(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        @Override
        public SignificanceHeuristic parse(XContentParser parser) throws IOException, QueryParsingException {
            ExecutableScript searchScript;
            XContentParser.Token token;
            NAMES_FIELD.match(parser.currentName(), ParseField.EMPTY_FLAGS);
            String script = null;
            HashMap<String, Object> params = new HashMap();
            String currentFieldName = null;
            ScriptService.ScriptType scriptType = ScriptService.ScriptType.INLINE;
            ScriptParameterParser scriptParameterParser = new ScriptParameterParser();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token.equals((Object)XContentParser.Token.FIELD_NAME)) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("params".equals(currentFieldName)) {
                        params = parser.map();
                        continue;
                    }
                    throw new ElasticsearchParseException("unknown object " + currentFieldName + " in script_heuristic");
                }
                if (scriptParameterParser.token(currentFieldName, token, parser)) continue;
                throw new ElasticsearchParseException("unknown field " + currentFieldName + " in script_heuristic");
            }
            ScriptParameterParser.ScriptParameterValue scriptValue = scriptParameterParser.getDefaultScriptParameterValue();
            if (scriptValue != null) {
                script = scriptValue.script();
                scriptType = scriptValue.scriptType();
            }
            String scriptLang = scriptParameterParser.lang();
            if (script == null) {
                throw new ElasticsearchParseException("No script found in script_heuristic");
            }
            try {
                searchScript = this.scriptService.executable(scriptLang, script, scriptType, ScriptContext.Standard.AGGS, params);
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("The script [" + script + "] could not be loaded", e);
            }
            return new ScriptHeuristic(searchScript, scriptLang, script, scriptType, params);
        }

        @Override
        public String[] getNames() {
            return NAMES_FIELD.getAllNamesIncludedDeprecated();
        }
    }
}

