/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

public class CommandBuilder {
    private static final String COMMON_ARGS = "&nohistory=true&format=java";
    private static final String DEBUG_ARG = "&debug=true";
    private final String pageName;
    private final String pageType;
    private String suiteFilter;
    private String excludeSuiteFilter;
    private boolean debug = true;

    public CommandBuilder(String pageName, String pageType) {
        this.pageName = pageName;
        this.pageType = pageType;
    }

    public CommandBuilder withSuiteFilter(String suiteFilter) {
        this.suiteFilter = suiteFilter;
        return this;
    }

    public CommandBuilder withExcludeSuiteFilter(String excludeSuiteFilter) {
        this.excludeSuiteFilter = excludeSuiteFilter;
        return this;
    }

    public CommandBuilder withDebug(boolean enabled) {
        this.debug = enabled;
        return this;
    }

    public String build() {
        String command = this.pageName + "?" + this.pageType + this.getCommandArgs();
        if (this.suiteFilter != null) {
            command = command + "&suiteFilter=" + this.suiteFilter;
        }
        if (this.excludeSuiteFilter != null) {
            command = command + "&excludeSuiteFilter=" + this.excludeSuiteFilter;
        }
        return command;
    }

    String getCommandArgs() {
        if (this.debug) {
            return "&debug=true&nohistory=true&format=java";
        }
        return COMMON_ARGS;
    }
}

