/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.reporting.BaseFormatter;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaFormatter
extends BaseFormatter
implements Closeable {
    private String mainPageName;
    private boolean isSuite = true;
    private TestSummary totalSummary = new TestSummary();
    private List<String> visitedTestPages = new ArrayList<String>();
    private Map<String, TestSummary> testSummaries = new HashMap<String, TestSummary>();
    private ResultsRepository resultsRepository;

    @Override
    public void testStarted(TestPage test) throws IOException {
        this.resultsRepository.open(test.getFullPath());
    }

    @Override
    public void testComplete(TestPage test, TestSummary testSummary) throws IOException {
        String fullPath = test.getFullPath();
        this.visitedTestPages.add(fullPath);
        this.totalSummary.add(testSummary);
        this.testSummaries.put(fullPath, new TestSummary(testSummary));
        this.resultsRepository.close();
        this.isSuite = this.isSuite && !this.mainPageName.equals(fullPath);
    }

    TestSummary getTestSummary(String testPath) {
        return this.testSummaries.get(testPath);
    }

    @Override
    public void testOutputChunk(String output) throws IOException {
        this.resultsRepository.write(output);
    }

    public TestSummary getTotalSummary() {
        return this.totalSummary;
    }

    public void setTotalSummary(TestSummary testSummary) {
        this.totalSummary = testSummary;
    }

    public void setResultsRepository(ResultsRepository mockResultsRepository) {
        this.resultsRepository = mockResultsRepository;
    }

    JavaFormatter(String suiteName) {
        this.mainPageName = suiteName;
    }

    @Override
    public void close() throws IOException {
        if (this.isSuite) {
            this.writeSummary(this.mainPageName);
        }
    }

    public void writeSummary(String suiteName) throws IOException {
        this.resultsRepository.open(suiteName);
        this.resultsRepository.write(new TestResultsSummaryTable(this.visitedTestPages, this.testSummaries).toString());
        this.resultsRepository.close();
    }

    public static class TestResultsSummaryTable {
        public static final String SUMMARY_FOOTER = "</table>";
        public static final String SUMMARY_HEADER = "<table><tr><td>Name</td><td>Right</td><td>Wrong</td><td>Exceptions</td></tr>";
        private List<String> visitedTestPages;
        private Map<String, TestSummary> testSummaries;

        public TestResultsSummaryTable(List<String> visitedTestPages, Map<String, TestSummary> testSummaries) {
            this.visitedTestPages = visitedTestPages;
            this.testSummaries = testSummaries;
        }

        public String summaryRow(String testName, TestSummary testSummary) {
            return new TestResultsSummaryTableRow(testName, testSummary).toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(SUMMARY_HEADER);
            for (String s : this.visitedTestPages) {
                sb.append(this.summaryRow(s, this.testSummaries.get(s)));
            }
            sb.append(SUMMARY_FOOTER);
            return sb.toString();
        }
    }

    public static class TestResultsSummaryTableRow {
        private String testName;
        private TestSummary testSummary;

        public TestResultsSummaryTableRow(String testName, TestSummary testSummary) {
            this.testName = testName;
            this.testSummary = testSummary;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<tr class=\"").append(this.getCssClass(this.testSummary)).append("\"><td>").append("<a href=\"").append(this.testName).append(".html\">").append(this.testName).append("</a>").append("</td><td>").append(this.testSummary.getRight()).append("</td><td>").append(this.testSummary.getWrong()).append("</td><td>").append(this.testSummary.getExceptions()).append("</td></tr>");
            return sb.toString();
        }

        private String getCssClass(TestSummary ts) {
            if (ts.getExceptions() > 0) {
                return "error";
            }
            if (ts.getWrong() > 0) {
                return "fail";
            }
            if (ts.getRight() > 0) {
                return "pass";
            }
            return "plain";
        }
    }

    public static class FolderResultsRepository
    implements ResultsRepository {
        private String outputPath;
        private TestResultPage testResultPage;

        public FolderResultsRepository(String outputPath) throws IOException {
            this.outputPath = outputPath;
            this.copyAssets();
        }

        @Override
        public void close() throws IOException {
            this.testResultPage.finish();
        }

        @Override
        public void open(String testName) throws IOException {
            this.testResultPage = new TestResultPage(this.outputPath, testName);
        }

        @Override
        public void write(String content) throws IOException {
            this.testResultPage.appendResultChunk(content);
        }

        public void addFile(String resource, String relativeFilePath) throws IOException {
            File dst = new File(this.outputPath, relativeFilePath);
            dst.getParentFile().mkdirs();
            FileCopier.copy(resource, dst);
        }

        private void copyAssets() throws IOException {
            String base = "/fitnesse/resources/";
            String cssDir = base + "css/";
            this.addFile(cssDir + "fitnesse.css", "css/fitnesse.css");
            this.addFile(cssDir + "fitnesse_wiki.css", "css/fitnesse_wiki.css");
            this.addFile(cssDir + "fitnesse_pages.css", "css/fitnesse_pages.css");
            this.addFile(cssDir + "fitnesse_straight.css", "css/fitnesse_straight.css");
            String javascriptDir = base + "javascript/";
            this.addFile(javascriptDir + "jquery-1.11.3.min.js", "javascript/jquery-1.11.3.min.js");
            this.addFile(javascriptDir + "fitnesse.js", "javascript/fitnesse.js");
            String imagesDir = base + "images/";
            this.addFile(imagesDir + "collapsibleOpen.png", "images/collapsibleOpen.png");
            this.addFile(imagesDir + "collapsibleClosed.png", "images/collapsibleClosed.png");
        }
    }

    public static class TestResultPage {
        private OutputStreamWriter currentWriter;

        public TestResultPage(String outputPath, String testName) throws IOException {
            File outputFile = new File(outputPath, testName + ".html");
            this.currentWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            this.writeHeaderFor(testName);
        }

        public void appendResultChunk(String content) throws IOException {
            this.currentWriter.write(content.replace("src=\"/files/images/", "src=\"images/"));
        }

        private void writeHeaderFor(String testName) throws IOException {
            this.currentWriter.write("<html><head><title>");
            this.currentWriter.write(testName);
            this.currentWriter.write("</title><meta http-equiv='Content-Type' content='text/html;charset=UTF-8'/><link rel='stylesheet' type='text/css' href='css/fitnesse.css'/><script src='javascript/jquery-1.11.3.min.js' type='text/javascript'></script><script src='javascript/fitnesse.js' type='text/javascript'></script></head><body><header><h2>");
            this.currentWriter.write(testName);
            this.currentWriter.write("</h2></header><article>");
        }

        public void finish() throws IOException {
            if (this.currentWriter != null) {
                this.currentWriter.write("</article></body></html>");
                this.currentWriter.close();
            }
        }
    }

    public static class FileCopier {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void copy(String src, File dst) throws IOException {
            InputStream in = null;
            OutputStream out = null;
            try {
                int len;
                in = FileCopier.class.getResourceAsStream(src);
                out = new FileOutputStream(dst);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static interface ResultsRepository {
        public void open(String var1) throws IOException;

        public void close() throws IOException;

        public void write(String var1) throws IOException;
    }
}

