/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.util.Clock;
import fitnesse.wiki.WikiPage;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class SaveRecorder {
    public static final Random ticketNumGen = new Random();
    private static final Map<String, Long> ticketRegistry = new HashMap<String, Long>();
    private static final Map<String, Long> saveTime = new HashMap<String, Long>();

    public static long pageSaved(WikiPage page, long ticketNumber) {
        long timeStamp = SaveRecorder.timeStamp();
        String name = page.getPageCrawler().getFullPath().toString();
        ticketRegistry.put(name, ticketNumber);
        saveTime.put(name, timeStamp);
        return timeStamp;
    }

    public static boolean changesShouldBeMerged(long thisEditTime, long ticket, WikiPage page) {
        return new MergeDeterminer(thisEditTime, ticket, page).shouldMerge();
    }

    public static long timeStamp() {
        return Clock.currentTimeInMillis();
    }

    public static long newTicket() {
        return ticketNumGen.nextLong();
    }

    public static void clear() {
        ticketRegistry.clear();
        saveTime.clear();
    }

    private static class MergeDeterminer {
        private long thisEditTime;
        private long ticket;
        private WikiPage page;
        private String fullPageName;

        public MergeDeterminer(long thisEditTime, long ticket, WikiPage page) {
            this.thisEditTime = thisEditTime;
            this.ticket = ticket;
            this.page = page;
            this.fullPageName = page.getPageCrawler().getFullPath().toString();
        }

        public boolean shouldMerge() {
            return this.isSaveOutOfOrder() && !this.isSameEditSession();
        }

        private boolean isSameEditSession() {
            long pageTicketId;
            boolean sameEdit = false;
            if (ticketRegistry.containsKey(this.fullPageName) && (pageTicketId = ((Long)ticketRegistry.get(this.fullPageName)).longValue()) == this.ticket) {
                sameEdit = true;
            }
            return sameEdit;
        }

        private boolean isSaveOutOfOrder() {
            long lastSaveTime;
            boolean returnValue = false;
            if (saveTime.containsKey(this.fullPageName) && (lastSaveTime = ((Long)saveTime.get(this.fullPageName)).longValue()) > this.thisEditTime) {
                returnValue = true;
            }
            return returnValue;
        }
    }
}

