/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.instructions;

import fitnesse.slim.SlimException;
import fitnesse.slim.instructions.InstructionExecutor;
import fitnesse.slim.instructions.InstructionResult;
import fitnesse.slim.instructions.SystemExitSecurityManager;

public abstract class Instruction {
    public static final Instruction NOOP_INSTRUCTION = new Instruction("NOOP"){

        @Override
        protected InstructionResult executeInternal(InstructionExecutor executor) throws SlimException {
            return new InstructionResult.Void(this.getId());
        }
    };
    private String id;

    public Instruction(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InstructionResult execute(InstructionExecutor executor) {
        InstructionResult result;
        try {
            SystemExitSecurityManager.activateIfWanted();
            result = this.executeInternal(executor);
        }
        catch (SlimException e) {
            result = new InstructionResult.Error(this.getId(), e);
        }
        catch (SystemExitSecurityManager.SystemExitException e) {
            result = new InstructionResult.Error(this.getId(), e);
        }
        finally {
            SystemExitSecurityManager.restoreOriginalSecurityManager();
        }
        return result;
    }

    protected abstract InstructionResult executeInternal(InstructionExecutor var1) throws SlimException;

    public String toString() {
        return "Instruction{id='" + this.id + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Instruction)) {
            return false;
        }
        Instruction that = (Instruction)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

