/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.protocol;

import fitnesse.slim.SlimError;
import fitnesse.slim.SlimException;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.InstructionExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SlimListBuilder {
    private final double slimVersion;

    public SlimListBuilder(double slimVersion) {
        this.slimVersion = slimVersion;
    }

    public List<Object> toList(List<Instruction> instructions) {
        final ArrayList<Object> statementsAsList = new ArrayList<Object>(instructions.size());
        for (final Instruction instruction : instructions) {
            ToListExecutor executor = new ToListExecutor(){

                private List<Object> mergeAsList(Object[] a, Object[] b) {
                    ArrayList<Object> l = new ArrayList<Object>(a.length + b.length);
                    l.addAll(Arrays.asList(a));
                    l.addAll(Arrays.asList(b));
                    return l;
                }

                @Override
                public void addPath(String path) throws SlimException {
                    statementsAsList.add(Arrays.asList(instruction.getId(), "import", path));
                }

                @Override
                public Object callAndAssign(String symbolName, String instanceName, String methodsName, Object ... arguments) throws SlimException {
                    Object[] list = new Object[]{instruction.getId(), "callAndAssign", symbolName, instanceName, methodsName};
                    statementsAsList.add(this.mergeAsList(list, arguments));
                    return null;
                }

                @Override
                public Object call(String instanceName, String methodName, Object ... arguments) throws SlimException {
                    Object[] list = new Object[]{instruction.getId(), "call", instanceName, methodName};
                    statementsAsList.add(this.mergeAsList(list, arguments));
                    return null;
                }

                @Override
                public void create(String instanceName, String className, Object ... constructorArgs) throws SlimException {
                    Object[] list = new Object[]{instruction.getId(), "make", instanceName, className};
                    statementsAsList.add(this.mergeAsList(list, constructorArgs));
                }

                @Override
                public void assign(String symbolName, Object value) {
                    if (SlimListBuilder.this.slimVersion < 0.4) {
                        throw new SlimError("The assign instruction is available as of SLIM protocol version 0.4");
                    }
                    Object[] list = new Object[]{instruction.getId(), "assign", symbolName, value};
                    statementsAsList.add(Arrays.asList(list));
                }
            };
            instruction.execute(executor);
        }
        return statementsAsList;
    }

    private static interface ToListExecutor
    extends InstructionExecutor {
    }
}

