/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.repository.query;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.repository.query.LdapQueryMethod;

abstract class AbstractLdapRepositoryQuery
implements RepositoryQuery {
    private final LdapQueryMethod queryMethod;
    private final Class<?> clazz;
    private final LdapOperations ldapOperations;

    public AbstractLdapRepositoryQuery(LdapQueryMethod queryMethod, Class<?> clazz, LdapOperations ldapOperations) {
        this.queryMethod = queryMethod;
        this.clazz = clazz;
        this.ldapOperations = ldapOperations;
    }

    public final Object execute(Object[] parameters) {
        LdapQuery query = this.createQuery(parameters);
        if (this.queryMethod.isCollectionQuery()) {
            return this.ldapOperations.find(query, this.clazz);
        }
        try {
            return this.ldapOperations.findOne(query, this.clazz);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    protected abstract LdapQuery createQuery(Object[] var1);

    Class<?> getClazz() {
        return this.clazz;
    }

    public final QueryMethod getQueryMethod() {
        return this.queryMethod;
    }
}

