/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseParseException;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicensePropertyMap;
import com.xebialabs.license.LicenseUtils;
import com.xebialabs.license.LicenseVerificationException;
import com.xebialabs.license.LicenseVersion3;
import com.xebialabs.license.LicenseVersionException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseReader {
    private static final Logger log = LoggerFactory.getLogger(LicenseReader.class);
    private static final String SECURITY_PROVIDER = "BC";
    public static final String PUB_KEY = "308201b73082012c06072a8648ce3804013082011f02818100fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c70215009760508f15230bccb292b982a2eb840bf0581cf502818100f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a038184000281807096070ddc40ba6dc6b65fddf6c76d1cb8527aa075f08550174aa69abe9fda0994a649969ffb77dce5c92405abc7976646733f5f66295b16688c43a716045d2c861ec11df8063c2d0273da0149b95f7964c7e1b2b80576611aefbd4f0ea2e5bd41472d6b0d91be09e770203588c82523855aca42141bd555fba5f44df1d97dc8";
    public static final String LICENSE_PREAMBLE = "--- License ---";
    public static final String LICENSE_PREAMBLE_V1 = "--- License V1 ---";
    public static final String SIGNATURE_ENDING = "--- End of Signature ---";
    public static final String SIGNATURE_PREAMBLE = "--- Signature (%s) ---";
    public static final Pattern LICENSE_PREAMBLE_REGEXP = Pattern.compile("^--- License ---$", 8);
    public static final Pattern LICENSE_PREAMBLE_V1_REGEXP = Pattern.compile("^--- License V1 ---$", 8);
    public static final Charset LICENSE_FILE_ENCODING = Charsets.UTF_8;
    private final Signature sig;

    public LicenseReader() {
        try {
            this.sig = Signature.getInstance("SHA1withDSA", SECURITY_PROVIDER);
            KeyFactory kf = KeyFactory.getInstance("DSA", SECURITY_PROVIDER);
            PublicKey publicKey = kf.generatePublic(new X509EncodedKeySpec(LicenseUtils.readKey(PUB_KEY)));
            this.sig.initVerify(publicKey);
        }
        catch (NoSuchProviderException e) {
            log.error("Security Provider not found. Installed providers: {} (Error: {})", (Object)Security.getProviders(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Algorithm not found. Available algorithms: {}", Security.getAlgorithms("Signature"));
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            log.error("Could not read key while checking license file");
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            log.error("Invalid key");
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            log.error("An exception was thrown: {}", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public License readLicense(File licenseFile) {
        String licenseData = this.readLicenseData(licenseFile);
        LicensePropertyMap licenseProperties = this.readLicenseProperties(licenseFile.toString(), licenseData);
        return this.createLicense(licenseProperties);
    }

    public License readFromBase64(String data) {
        String decoded = LicenseUtils.decodeBase64License(data);
        try {
            String licenseContent = this.readLicenseContent("input", decoded);
            LicensePropertyMap licenseProperties = this.readLicenseProperties("input", licenseContent);
            return this.createLicense(licenseProperties);
        }
        catch (IOException e) {
            throw new LicenseParseException("Unable to read input", e);
        }
    }

    private String readFileToString(File file) throws IOException {
        return Files.asCharSource((File)file, (Charset)LICENSE_FILE_ENCODING).read().replaceAll("\\r\\n?", "\n");
    }

    private LicensePropertyMap readLicenseProperties(String source, String licenseData) {
        LicensePropertyMap licenseProperties = new LicensePropertyMap();
        String[] lines = licenseData.split("\r?\n");
        Pattern p = Pattern.compile("^([^:]+):\\s+(.+)$");
        for (String line : lines) {
            Matcher matches = p.matcher(line);
            if (!matches.matches()) {
                throw new LicenseParseException(String.format("Unrecognized line '%s' in from %s", line, source));
            }
            String key = matches.group(1);
            String value = matches.group(2);
            licenseProperties.set(LicenseProperty.get(key), value);
        }
        return licenseProperties;
    }

    private License createLicense(LicensePropertyMap licenseProperties) {
        String versionProperty = (String)licenseProperties.get(LicenseProperty.LICENSE_VERSION);
        if (Integer.toString(3).equals(versionProperty)) {
            return new LicenseVersion3(licenseProperties);
        }
        throw new LicenseVersionException(String.format("Unsupported license version %s", versionProperty != null ? versionProperty : "1"));
    }

    private String readLicenseData(File licenseFile) {
        try {
            String data = this.readFileToString(licenseFile);
            String decoded = LicenseUtils.decodeIfNecessary(data);
            return this.readLicenseContent("License file '" + licenseFile.toString() + "'", decoded);
        }
        catch (IOException e) {
            throw new LicenseParseException(String.format("Unable to read license file '%s'", licenseFile), e);
        }
    }

    private String readLicenseContent(String source, String data) throws IOException {
        log.debug("License file {} contents: {}", (Object)source, (Object)data);
        String lineEnding = "\n";
        Matcher versionMatcher = LICENSE_PREAMBLE_REGEXP.matcher(data);
        if (!versionMatcher.find() && !(versionMatcher = LICENSE_PREAMBLE_V1_REGEXP.matcher(data)).find()) {
            throw new LicenseVersionException(String.format("License file '%s' missing preamble", source));
        }
        String sigPreamble = String.format(SIGNATURE_PREAMBLE, this.sig.getAlgorithm()) + "\n";
        int sigOffset = data.indexOf(sigPreamble);
        if (sigOffset == -1) {
            throw new LicenseParseException(String.format("%s missing signature start", source));
        }
        int preambleLength = versionMatcher.end() + "\n".length();
        int licensePreambleLength = sigPreamble.length();
        if (sigOffset < preambleLength) {
            throw new LicenseParseException("Malformed license file");
        }
        int startOffset = data.indexOf(versionMatcher.group(0));
        if (startOffset > 0) {
            throw new LicenseParseException("Unexpected data found before boundary");
        }
        int terminatorOffset = data.indexOf(SIGNATURE_ENDING);
        String signature = data.substring(sigOffset + licensePreambleLength, terminatorOffset);
        String licenseContent = data.substring(preambleLength, sigOffset);
        log.debug("License content length: {} Signature length: {}", (Object)licenseContent.length(), (Object)signature.length());
        String beyondBorder = data.substring(terminatorOffset + SIGNATURE_ENDING.length(), data.length()).trim();
        if (beyondBorder.length() > 0) {
            throw new LicenseParseException("Unexpected data found beyond boundary");
        }
        try {
            this.sig.update(licenseContent.getBytes(LICENSE_FILE_ENCODING));
        }
        catch (SignatureException e) {
            throw new LicenseVerificationException(String.format("Unable to verify signature from license '%s'", source), e);
        }
        byte[] sigdata = LicenseUtils.readKey(signature);
        try {
            if (!this.sig.verify(sigdata)) {
                throw new LicenseVerificationException(String.format("%s is not valid. Signature could not be verified.", source));
            }
        }
        catch (SignatureException e) {
            throw new LicenseVerificationException(String.format("Unable to verify signature from license '%s'", source), e);
        }
        return licenseContent;
    }
}

