/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.xebialabs.xlt.plugin.api.repository.QualificationsRepository;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.QualificationResult;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QualificationsRepositoryImpl
implements QualificationsRepository {
    private final TestSpecificationRepository testSpecificationRepository;

    @Autowired
    public QualificationsRepositoryImpl(TestSpecificationRepository testSpecificationRepository) {
        this.testSpecificationRepository = testSpecificationRepository;
    }

    public Map<String, String> getLatestQualificationResult(String testSpecificationName) {
        BaseTestSpecification baseTestSpecification = this.testSpecificationRepository.get(testSpecificationName);
        Optional<QualificationResult> optional = this.testSpecificationRepository.getLatestQualificationResult(baseTestSpecification);
        HashMap<String, String> result = new HashMap<String, String>();
        if (optional.isPresent()) {
            QualificationResult qualificationResult = (QualificationResult)((Object)optional.get());
            switch (qualificationResult.getResult()) {
                case PASSED: {
                    result.put("result", QualificationResult.Result.PASSED.toString());
                    break;
                }
                case FAILED: {
                    result.put("result", QualificationResult.Result.FAILED.toString());
                }
            }
            if (!Strings.isNullOrEmpty((String)qualificationResult.getLastFailureReason())) {
                result.put("message", qualificationResult.getLastFailureReason());
            }
        }
        return result;
    }
}

