/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.Synthetic;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.DashboardTile;
import com.xebialabs.xltest.domain.QualificationResult;
import com.xebialabs.xltest.domain.Report;
import com.xebialabs.xltest.domain.TestSpecificationSet;
import com.xebialabs.xltest.domain.TestToolFactory;
import com.xebialabs.xltest.domain.TestToolNameAware;
import com.xebialabs.xltest.repository.DashboardRepository;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.repository.TestToolRepository;
import com.xebialabs.xltest.repository.XltTestSpecificationNotFoundException;
import com.xebialabs.xltest.repository.XltValidationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.TermFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TestSpecificationRepository {
    private static final Logger LOG = LoggerFactory.getLogger(TestSpecificationRepository.class);
    private final DashboardRepository dashboardRepository;
    private final RepositoryService repository;
    private final TestToolRepository testToolRepository;
    private final EventRepository eventRepository;

    @Autowired
    public TestSpecificationRepository(RepositoryService repositoryService, DashboardRepository dashboardRepository, TestToolRepository testToolRepository, EventRepository eventRepository) {
        this.repository = repositoryService;
        this.dashboardRepository = dashboardRepository;
        this.testToolRepository = testToolRepository;
        this.eventRepository = (EventRepository)Preconditions.checkNotNull((Object)eventRepository);
    }

    public BaseTestSpecification getSpecificationForProject(String projectId, String testSpecificationId) {
        BaseTestSpecification testSpec;
        try {
            testSpec = (BaseTestSpecification)this.repository.read(Synthetic.createSpecificationForProjectId(projectId, testSpecificationId));
        }
        catch (NotFoundException ex) {
            throw new XltTestSpecificationNotFoundException(testSpecificationId);
        }
        return testSpec;
    }

    public List<BaseTestSpecification> getAll() {
        SearchParameters searchParams = new SearchParameters();
        searchParams.setType(Type.valueOf(BaseTestSpecification.class));
        searchParams.setDepth(2);
        return this.repository.listEntities(searchParams);
    }

    public List<TestSpecificationSet> getAllSets() {
        SearchParameters searchParams = new SearchParameters();
        searchParams.setType(Type.valueOf(TestSpecificationSet.class));
        searchParams.setDepth(1);
        return this.repository.listEntities(searchParams);
    }

    public TestSpecificationSet getTestSpecificationSetById(String testSpecificationId) {
        BaseTestSpecification baseTestSpecification = this.getById(testSpecificationId);
        if (!baseTestSpecification.getType().instanceOf(Type.valueOf(TestSpecificationSet.class))) {
            throw new IllegalArgumentException(String.format("Test Specification with id [%s] is not a subtype of xlt.TestSpecificationSet", testSpecificationId));
        }
        return (TestSpecificationSet)baseTestSpecification;
    }

    public ActiveTestSpecification getActiveTestSpecificationById(String testSpecificationId) {
        BaseTestSpecification baseTestSpecification = this.getById(testSpecificationId);
        if (!baseTestSpecification.getType().instanceOf(Type.valueOf(ActiveTestSpecification.class))) {
            throw new IllegalArgumentException(String.format("Test Specification with id [%s] is not a subtype of xlt.ActiveTestSpecification", testSpecificationId));
        }
        return (ActiveTestSpecification)baseTestSpecification;
    }

    public BaseTestSpecification getById(String testSpecificationId) {
        SearchParameters searchParams = new SearchParameters();
        searchParams.setName(testSpecificationId);
        searchParams.setType(Type.valueOf(BaseTestSpecification.class));
        searchParams.setDepth(2);
        return this.listOneResult(searchParams, testSpecificationId);
    }

    public BaseTestSpecification get(String testSpecificationName) {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setName(testSpecificationName);
        searchParameters.setType(Type.valueOf(BaseTestSpecification.class));
        searchParameters.setDepth(2);
        return this.listOneResult(searchParameters, testSpecificationName);
    }

    public List<Descriptor> findReportsForTestSpecification(String testSpecificationId) {
        BaseTestSpecification testSpecification = this.getById(testSpecificationId);
        return this.findReportsForTestSpecification(testSpecification);
    }

    public List<Descriptor> findReportsForTestSpecification(BaseTestSpecification testSpecification) {
        String category = "set";
        if (testSpecification instanceof TestToolNameAware) {
            TestToolFactory testTool = this.testToolRepository.findTestToolConfigurationByName(((TestToolNameAware)((Object)testSpecification)).getTestToolName());
            category = testTool.getCategory();
        }
        return TestSpecificationRepository.findReportsForCategory(category);
    }

    private static List<Descriptor> findReportsForCategory(String type) {
        Collection children = DescriptorRegistry.getSubtypes((Type)Type.valueOf(Report.class));
        List<Descriptor> result = children.stream().map(child -> DescriptorRegistry.getDescriptor((Type)child)).filter(descriptor -> !descriptor.isVirtual()).filter(descriptor -> {
            Set reportCategories = (Set)descriptor.getPropertyDescriptor("applicableCategories").getDefaultValue();
            return reportCategories.contains(type);
        }).filter(descriptor -> (Boolean)descriptor.getPropertyDescriptor("visibleOnTestSpecificationLevel").getDefaultValue()).collect(Collectors.toList());
        result.sort((o1, o2) -> o1.getLabel().compareTo(o2.getLabel()));
        return result;
    }

    public void deleteTestSpecification(String projectName, String testSpecificationName) {
        this.deleteTestSpecification(projectName, testSpecificationName, true);
    }

    public void deleteTestSpecification(String projectName, String testSpecificationName, boolean force) {
        LOG.info("removing test specification:" + testSpecificationName);
        this.dashboardRepository.deleteDashboardTilesBySpecificationName(testSpecificationName);
        BaseTestSpecification testSpecification = this.getSpecificationForProject(projectName, testSpecificationName);
        if (force) {
            this.removeReferences(testSpecification, this.getAll());
        }
        this.deleteTestSpecification(testSpecification);
        LOG.info("removed test specification:" + testSpecificationName);
    }

    public void deleteTestSpecificationReferenceFromParent(String projectName, String testSpecificationNameToRemove, String testSpecificationNameOfParent) {
        BaseTestSpecification testSpecificationToRemove = this.getSpecificationForProject(projectName, testSpecificationNameToRemove);
        TestSpecificationSet testSpecificationParent = (TestSpecificationSet)this.getSpecificationForProject(projectName, testSpecificationNameOfParent);
        ArrayList<BaseTestSpecification> newListOfChildren = new ArrayList<BaseTestSpecification>();
        boolean foundReferenceToRemove = false;
        for (BaseTestSpecification testSpec : testSpecificationParent.getTestSpecifications()) {
            if (testSpec.getId().equals(testSpecificationToRemove.getId())) {
                foundReferenceToRemove = true;
                continue;
            }
            newListOfChildren.add(testSpec);
        }
        if (foundReferenceToRemove) {
            testSpecificationParent.setTestSpecifications(newListOfChildren);
            try {
                this.repository.createOrUpdate((ConfigurationItem[])new TestSpecificationSet[]{testSpecificationParent});
            }
            catch (Exception e) {
                LOG.error("Error removing reference of specification with name {} for specification with parent name {}", (Object)testSpecificationNameToRemove, (Object)testSpecificationNameOfParent);
                throw e;
            }
        } else {
            throw new IllegalArgumentException("Specification " + testSpecificationNameToRemove + " cannot be found, and thus not be removed from parent " + testSpecificationNameOfParent);
        }
    }

    private void removeReferences(BaseTestSpecification testSpecificationToRemove, List<BaseTestSpecification> allTestSpecifications) {
        for (BaseTestSpecification testSpec : allTestSpecifications) {
            if (!(testSpec instanceof TestSpecificationSet)) continue;
            this.removeTestSpecificationReferenceFromSuperSetsRecursively(testSpecificationToRemove, (TestSpecificationSet)testSpec);
        }
        List<DashboardTile> dashboardTiles = this.dashboardRepository.findDashboardTilesBySpecificationName(testSpecificationToRemove.getName());
        for (DashboardTile dashboardTile : dashboardTiles) {
            this.dashboardRepository.deleteTile(dashboardTile);
        }
    }

    private void deleteTestSpecification(BaseTestSpecification testSpecificationToRemove) {
        this.repository.delete(new String[]{testSpecificationToRemove.getId()});
        this.deleteAssociatedEvents(testSpecificationToRemove);
    }

    private void deleteAssociatedEvents(BaseTestSpecification testSpecification) {
        LOG.info("About to remove the events from elastic search");
        TermFilterBuilder filterBuilder = FilterBuilders.termFilter((String)"@testSpecification", (String)testSpecification.getName());
        this.eventRepository.delete((FilterBuilder)filterBuilder);
    }

    private void removeTestSpecificationReferenceFromSuperSetsRecursively(BaseTestSpecification testSpecificationToRemove, TestSpecificationSet testSetSpec) {
        ArrayList<BaseTestSpecification> newListOfChildren = new ArrayList<BaseTestSpecification>();
        boolean referencePresent = false;
        testSetSpec = (TestSpecificationSet)this.get(testSetSpec.getName());
        for (BaseTestSpecification child : testSetSpec.getTestSpecifications()) {
            if (child.getId().equals(testSpecificationToRemove.getId())) {
                referencePresent = true;
                continue;
            }
            if (child instanceof TestSpecificationSet) {
                this.removeTestSpecificationReferenceFromSuperSetsRecursively(testSpecificationToRemove, (TestSpecificationSet)child);
            }
            newListOfChildren.add(child);
        }
        if (referencePresent) {
            testSetSpec.setTestSpecifications(newListOfChildren);
            this.repository.createOrUpdate((ConfigurationItem[])new TestSpecificationSet[]{testSetSpec});
        }
    }

    private BaseTestSpecification listOneResult(SearchParameters searchParameters, String testSpecificationName) {
        List results = this.repository.listEntities(searchParameters);
        if (results.isEmpty()) {
            throw new XltTestSpecificationNotFoundException(testSpecificationName);
        }
        if (results.size() > 1) {
            throw new IllegalStateException(String.format("Expected one TestSpecification but got %d results for [%s]", results.size(), testSpecificationName));
        }
        return (BaseTestSpecification)((Object)results.get(0));
    }

    public List<TestSpecificationSet> findTestSpecificationSetsForSpecification(String testSpecificationName) {
        ArrayList<TestSpecificationSet> found = new ArrayList<TestSpecificationSet>();
        List<TestSpecificationSet> testSpecificationSets = this.getAllSets();
        for (TestSpecificationSet testSpecificationSet : testSpecificationSets) {
            for (BaseTestSpecification testSpecification : testSpecificationSet.getTestSpecifications()) {
                if (!testSpecification.getName().equals(testSpecificationName)) continue;
                found.add(testSpecificationSet);
            }
        }
        return found;
    }

    public void validate(BaseTestSpecification testSpecification) {
        this.checkAndCorrectTestTool(testSpecification);
        this.checkQualification(testSpecification);
        this.checkTitle(testSpecification);
    }

    private void checkTitle(BaseTestSpecification testSpecification) {
        if (Strings.isNullOrEmpty((String)testSpecification.getTitle())) {
            throw new XltValidationException("The title cannot be null or empty", new Object[0]);
        }
    }

    private void checkAndCorrectTestTool(BaseTestSpecification testSpecification) {
        if (!(testSpecification instanceof TestToolNameAware)) {
            return;
        }
        TestToolNameAware testToolTestSpec = (TestToolNameAware)((Object)testSpecification);
        String testTool = testToolTestSpec.getTestToolName();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)testTool) ? 1 : 0) != 0);
        List<Descriptor> testTools = this.testToolRepository.getTestToolConfigurations();
        for (Descriptor tool : testTools) {
            if (!tool.getType().toString().equalsIgnoreCase(testTool)) continue;
            testToolTestSpec.setTestToolName(tool.getType().toString());
            return;
        }
        if (LOG.isDebugEnabled()) {
            List<String> toolNames = this.getTestToolNames(testTools);
            LOG.debug("Testtool {} is not included in the list of testtools available: {}", (Object)testTool, toolNames);
        }
        ValidationMessage validationMessage = ValidationMessage.error((String)testSpecification.getId(), (String)"testToolName", (String)String.format("TestTool %s is not supported. Please select one from the dropdown menu.", testTool));
        testSpecification.set$validationMessages(Collections.singletonList(validationMessage));
        throw new XltValidationException(String.format("TestTool name: %s is not supported", testTool), new Object[0]);
    }

    private List<String> getTestToolNames(Collection<Descriptor> testTools) {
        return testTools.stream().map(tool -> tool.getType().toString()).collect(Collectors.toList());
    }

    private void checkQualification(BaseTestSpecification testSpecification) {
        boolean exists;
        if (!testSpecification.hasQualificationType()) {
            return;
        }
        String qualificationType = testSpecification.getQualificationType();
        try {
            exists = DescriptorRegistry.exists((Type)Type.valueOf((String)qualificationType));
        }
        catch (Exception e) {
            throw new XltValidationException(e.getMessage(), new Object[0]);
        }
        if (!exists) {
            throw new XltValidationException("Qualification type: %s does not exist", qualificationType);
        }
    }

    public List<QualificationResult> getQualificationResults(BaseTestSpecification testSpecification) {
        SearchParameters parameters = new SearchParameters();
        parameters.setType(Type.valueOf(QualificationResult.class));
        parameters.setAncestor(testSpecification.getId());
        parameters.setDepth(1);
        List qualificationResults = this.repository.listEntities(parameters);
        Collections.sort(qualificationResults);
        return qualificationResults;
    }

    private List<QualificationResult> getSuperSetQualificationResult(TestSpecificationSet testSpecificationSet) {
        QualificationResult result = QualificationResult.newInstance(testSpecificationSet, UUID.randomUUID().toString());
        result.setResult(QualificationResult.Result.PASSED);
        for (BaseTestSpecification testSpec : testSpecificationSet.getAllChildren()) {
            List<QualificationResult> childResults = this.getQualificationResults(testSpec);
            if (childResults.isEmpty()) {
                result = new QualificationResult();
                result.setResult(QualificationResult.Result.FAILED);
                result.addFailureReason("Not all children have a result");
                return Collections.singletonList(result);
            }
            result = QualificationResult.merge(result, childResults.get(childResults.size() - 1));
        }
        return Collections.singletonList(result);
    }

    public Optional<QualificationResult> getLatestQualificationResult(BaseTestSpecification testSpec) {
        List<QualificationResult> qualificationResults = testSpec instanceof TestSpecificationSet ? this.getSuperSetQualificationResult((TestSpecificationSet)testSpec) : this.getQualificationResults(testSpec);
        return qualificationResults.isEmpty() ? Optional.absent() : Optional.of((Object)((Object)qualificationResults.get(qualificationResults.size() - 1)));
    }

    public void addQualificationResult(QualificationResult qualificationResult) {
        this.repository.create((ConfigurationItem[])new QualificationResult[]{qualificationResult});
    }
}

