/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthenticatedUserToMdcFilter
implements Filter {
    public static final String USERNAME = "username";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Authentication auth;
            SecurityContext context = SecurityContextHolder.getContext();
            if (context != null && (auth = context.getAuthentication()) != null && !auth.getName().isEmpty()) {
                MDC.put((String)USERNAME, (String)auth.getName());
            }
            chain.doFilter(request, response);
        }
        finally {
            MDC.remove((String)USERNAME);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

