/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import com.xebialabs.deployit.security.SecretKeyHolder;
import com.xebialabs.xlplatform.config.package$;
import com.xebialabs.xlplatform.config.package$ConfigPasswordUtils$;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.convert.WrapAsScala;
import scala.runtime.BoxedUnit;
import scala.util.Try$;

public final class ConfigLoader$
implements Logging {
    public static final ConfigLoader$ MODULE$;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    static {
        new ConfigLoader$();
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ConfigLoader$ configLoader$ = this;
        synchronized (configLoader$) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public Config loadWithDynamic(String configResource) {
        this.info((Function0<Object>)new Serializable(configResource){
            public static final long serialVersionUID = 0L;
            private final String configResource$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.configResource$1}));
            }
            {
                this.configResource$1 = configResource$1;
            }
        });
        return this.resolveWithDynamic(ConfigFactory.parseResources((String)configResource));
    }

    public Config loadSecuredWithDynamic(String configResource, SecretKeyHolder keyHolder, Function1<String, Option<File>> findResourceFile) {
        this.replacePlainTextIfNeeded(configResource, keyHolder, findResourceFile);
        return package$ConfigPasswordUtils$.MODULE$.decrypted$extension(package$.MODULE$.ConfigPasswordUtils(this.loadWithDynamic(configResource)), keyHolder);
    }

    public Function1<String, Option<File>> loadSecuredWithDynamic$default$3() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<File> apply(String resource) {
                return ConfigLoader$.MODULE$.com$xebialabs$xlplatform$config$ConfigLoader$$findFirstInClassPath(resource);
            }
        };
    }

    private void replacePlainTextIfNeeded(String configResource, SecretKeyHolder keyHolder, Function1<String, Option<File>> findResourceFile) {
        Config config = ConfigFactory.parseResources((String)configResource);
        if (package$ConfigPasswordUtils$.MODULE$.hasPlainPasswords$extension(package$.MODULE$.ConfigPasswordUtils(config), keyHolder)) {
            this.warn((Function0<Object>)new Serializable(configResource){
                public static final long serialVersionUID = 0L;
                private final String configResource$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configuration file ", " contains plain text passwords"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.configResource$2}));
                }
                {
                    this.configResource$2 = configResource$2;
                }
            });
            Option option = (Option)findResourceFile.apply((Object)configResource);
            if (option instanceof Some) {
                Some some = (Some)option;
                File file = (File)some.x();
                this.info((Function0<Object>)new Serializable(file){
                    public static final long serialVersionUID = 0L;
                    private final File file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing secured configuration file to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1.getAbsolutePath()}));
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
                Files.write(file.toPath(), (Iterable<? extends CharSequence>)scala.collection.convert.package$.MODULE$.wrapAll().seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{package$ConfigPasswordUtils$.MODULE$.encrypted$extension(package$.MODULE$.ConfigPasswordUtils(config), keyHolder).root().render(ConfigRenderOptions.defaults().setFormatted(true).setJson(false).setOriginComments(false).setComments(true))}))), new OpenOption[0]);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.warn((Function0<Object>)new Serializable(configResource){
                    public static final long serialVersionUID = 0L;
                    private final String configResource$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configuration file ", " cannot be found in file system. Encryption aborted!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.configResource$2}));
                    }
                    {
                        this.configResource$2 = configResource$2;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    private Config resolveWithDynamic(Config config) {
        return ConfigFactory.parseResources((String)"dynamic-reference.conf").withFallback((ConfigMergeable)ConfigFactory.load((Config)config)).resolve();
    }

    public Option<File> com$xebialabs$xlplatform$config$ConfigLoader$$findFirstInClassPath(String resource) {
        return ((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).enumerationAsScalaIterator(ClassLoaderUtils$.MODULE$.classLoader().getResources(resource)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<File> apply(URL url) {
                return Try$.MODULE$.apply((Function0)new Serializable(this, url){
                    public static final long serialVersionUID = 0L;
                    private final URL url$1;

                    public final File apply() {
                        return new File(this.url$1.toURI());
                    }
                    {
                        this.url$1 = url$1;
                    }
                }).toOption();
            }
        }).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<File> maybeFile) {
                return ConfigLoader$.MODULE$.com$xebialabs$xlplatform$config$ConfigLoader$$fileExists$1(maybeFile);
            }
        }).flatten(Predef$.MODULE$.$conforms());
    }

    public final boolean com$xebialabs$xlplatform$config$ConfigLoader$$fileExists$1(Option maybeFile) {
        return maybeFile.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.exists();
            }
        });
    }

    private ConfigLoader$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

