/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.testsystems.TestSummary;
import java.io.File;
import java.util.Date;

public class TestResultRecord {
    private final File file;
    private final Date date;
    private final int right;
    private final int wrong;
    private final int ignores;
    private final int exceptions;

    public TestResultRecord(File file, Date date, int right, int wrong, int ignores, int exceptions) {
        this.file = file;
        this.date = date;
        this.right = right;
        this.wrong = wrong;
        this.ignores = ignores;
        this.exceptions = exceptions;
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public File getFile() {
        return this.file;
    }

    public String getWikiPageName() {
        return this.file.getParentFile().getName();
    }

    public int getRight() {
        return this.right;
    }

    public int getWrong() {
        return this.wrong;
    }

    public int getIgnores() {
        return this.ignores;
    }

    public int getExceptions() {
        return this.exceptions;
    }

    public TestSummary toTestSummary() {
        return new TestSummary(this.right, this.wrong, this.ignores, this.exceptions);
    }
}

