/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.Converter;
import fitnesse.slim.SlimError;
import fitnesse.slim.converters.ConverterRegistry;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ConverterSupport {
    public static Object[] convertArgs(Object[] args, Type[] argumentTypes) {
        Object[] convertedArgs = new Object[args.length];
        for (int i = 0; i < argumentTypes.length; ++i) {
            if (argumentTypes[i] instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)argumentTypes[i];
                convertedArgs[i] = ConverterSupport.convertArg(args[i], (Class)parameterizedType.getRawType(), (ParameterizedType)argumentTypes[i]);
                continue;
            }
            convertedArgs[i] = ConverterSupport.convertArg(args[i], (Class)argumentTypes[i], null);
        }
        return convertedArgs;
    }

    private static <T> T convertArg(Object arg, Class<T> argumentType, ParameterizedType argumentParameterizedType) throws SlimError {
        if (arg == null || argumentType.isInstance(arg) && String.class != argumentType) {
            return (T)arg;
        }
        Converter<T> converter = ConverterRegistry.getConverterForClass(argumentType, argumentParameterizedType);
        if (converter != null) {
            return converter.fromString(arg.toString());
        }
        throw new SlimError(String.format("message:<<%s %s.>>", "NO_CONVERTER_FOR_ARGUMENT_NUMBER", argumentType.getName()));
    }
}

