/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.StackTraceEnricher;

public class SlimException
extends Exception {
    private static final String PRETTY_PRINT_TAG_START = "message:<<";
    private static final String PRETTY_PRINT_TAG_END = ">>";
    private final String tag;
    private final boolean prettyPrint;

    public SlimException(String message) {
        this(message, "", false);
    }

    public SlimException(String message, boolean prettyPrint) {
        this(message, "", prettyPrint);
    }

    public SlimException(String message, String tag) {
        this(message, tag, false);
    }

    public SlimException(String message, String tag, boolean prettyPrint) {
        super(message);
        this.tag = tag;
        this.prettyPrint = prettyPrint;
    }

    public SlimException(Throwable cause) {
        this(cause, "", false);
    }

    public SlimException(Throwable cause, boolean prettyPrint) {
        this(cause, "", prettyPrint);
    }

    public SlimException(Throwable cause, String tag) {
        this(cause, tag, false);
    }

    public SlimException(Throwable cause, String tag, boolean prettyPrint) {
        super(cause);
        this.tag = tag;
        this.prettyPrint = prettyPrint;
    }

    public SlimException(String message, Throwable cause) {
        this(message, cause, false);
    }

    public SlimException(String message, Throwable cause, boolean prettyPrint) {
        this(message, cause, "", prettyPrint);
    }

    public SlimException(String message, Throwable cause, String tag) {
        this(message, cause, tag, false);
    }

    public SlimException(String message, Throwable cause, String tag, boolean prettyPrint) {
        super(message, cause);
        this.tag = tag;
        this.prettyPrint = prettyPrint;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean prettyPrint() {
        return this.prettyPrint;
    }

    @Override
    public String toString() {
        String msg;
        StringBuilder sb = new StringBuilder();
        if (SlimException.isStopTestException(this.getCause())) {
            sb.append("__EXCEPTION__:ABORT_SLIM_TEST:");
        } else if (SlimException.isStopSuiteException(this.getCause())) {
            sb.append("__EXCEPTION__:ABORT_SLIM_SUITE:");
        } else {
            sb.append("__EXCEPTION__:");
        }
        if (this.prettyPrint) {
            sb.append(PRETTY_PRINT_TAG_START);
        }
        if (this.tag != null && !this.tag.isEmpty()) {
            sb.append(this.tag).append(" ");
        }
        if ((msg = this.getMessage()) != null && !msg.isEmpty()) {
            sb.append(msg);
        }
        if (this.prettyPrint) {
            sb.append(PRETTY_PRINT_TAG_END);
        }
        StackTraceEnricher enricher = new StackTraceEnricher();
        if (this.getCause() != null) {
            sb.append(enricher.getStackTraceAsString(this.getCause()));
        } else {
            if (this.getStackTrace() == null || this.getStackTrace().length == 0) {
                this.fillInStackTrace();
            }
            sb.append(enricher.getStackTraceAsString(this));
        }
        return sb.toString();
    }

    public static boolean isStopTestException(Throwable t) {
        return t != null && t.getClass().toString().contains("StopTest");
    }

    public static boolean isStopSuiteException(Throwable t) {
        return t != null && t.getClass().toString().contains("StopSuite") || t instanceof InterruptedException;
    }
}

