/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.JavaSlimFactory;
import fitnesse.slim.SlimError;
import fitnesse.slim.SlimFactory;
import fitnesse.slim.SlimServer;
import fitnesse.slim.fixtureInteraction.DefaultInteraction;
import fitnesse.slim.fixtureInteraction.FixtureInteraction;
import fitnesse.socketservice.SocketFactory;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import util.CommandLine;

public class SlimService {
    public static final String OPTION_DESCRIPTOR = "[-v] [-i interactionClass] [-s statementTimeout] [-d] [-ssl parameterClass] port";
    static FixtureInteraction interaction = SlimService.getInteraction(null);
    private final ServerSocket serverSocket;
    private final SlimServer slimServer;
    private final boolean daemon;
    private final Executor executor = Executors.newFixedThreadPool(5);

    public static void main(String[] args) throws IOException {
        Options options = SlimService.parseCommandLine(args);
        if (options != null) {
            try {
                SlimService.startWithFactory(JavaSlimFactory.createJavaSlimFactory(options), options);
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Exiting as exception occured: " + e.getMessage());
                System.exit(98);
            }
        } else {
            SlimService.parseCommandLineFailed(args);
        }
    }

    protected static void parseCommandLineFailed(String[] args) {
        System.err.println("Invalid command line arguments: " + Arrays.asList(args));
        System.err.println("Usage:");
        System.err.println("    " + SlimService.class.getName() + " " + OPTION_DESCRIPTOR);
    }

    public static void startWithFactory(SlimFactory slimFactory, Options options) throws IOException {
        SlimService slimservice = new SlimService(slimFactory.getSlimServer(), options.port, options.interaction, options.daemon, options.useSSL, options.sslParameterClassName);
        slimservice.accept();
    }

    public static Options parseCommandLine(String[] args) {
        CommandLine commandLine = new CommandLine(OPTION_DESCRIPTOR);
        if (commandLine.parse(args)) {
            boolean verbose = commandLine.hasOption("v");
            String interactionClassName = commandLine.getOptionArgument("i", "interactionClass");
            String portString = commandLine.getArgument("port");
            int port = portString == null ? 8099 : Integer.parseInt(portString);
            String statementTimeoutString = commandLine.getOptionArgument("s", "statementTimeout");
            Integer statementTimeout = statementTimeoutString == null ? null : Integer.valueOf(Integer.parseInt(statementTimeoutString));
            boolean daemon = commandLine.hasOption("d");
            String sslParameterClassName = commandLine.getOptionArgument("ssl", "parameterClass");
            boolean useSSL = commandLine.hasOption("ssl");
            return new Options(verbose, port, SlimService.getInteraction(interactionClassName), daemon, statementTimeout, useSSL, sslParameterClassName);
        }
        return null;
    }

    public SlimService(SlimServer slimServer, int port, FixtureInteraction interaction, boolean daemon, boolean useSSL, String sslParameterClassName) throws IOException {
        SlimService.interaction = interaction;
        this.daemon = daemon;
        this.slimServer = slimServer;
        try {
            this.serverSocket = useSSL ? SocketFactory.createSslServerSocket(port, useSSL, sslParameterClassName) : SocketFactory.createServerSocket(port);
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of Memory. Aborting.");
            e.printStackTrace();
            System.exit(99);
            throw e;
        }
        catch (BindException e) {
            System.err.println("Can not bind to port " + port + ". Aborting.");
            e.printStackTrace();
            throw e;
        }
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept() throws IOException {
        try {
            if (this.daemon) {
                this.acceptMany();
            } else {
                this.acceptOne();
            }
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of Memory. Aborting");
            e.printStackTrace();
            System.exit(99);
        }
        finally {
            this.serverSocket.close();
        }
    }

    private void acceptMany() throws IOException {
        while (true) {
            final Socket socket = this.serverSocket.accept();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        SlimService.this.handle(socket);
                    }
                    catch (IOException e) {
                        throw new SlimError(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(Socket socket) throws IOException {
        try {
            this.slimServer.serve(socket);
        }
        finally {
            socket.close();
        }
    }

    private void acceptOne() throws IOException {
        Socket socket = this.serverSocket.accept();
        this.handle(socket);
    }

    private static FixtureInteraction getInteraction(String interactionClassName) {
        if (interactionClassName == null) {
            return new DefaultInteraction();
        }
        try {
            return (FixtureInteraction)Class.forName(interactionClassName).newInstance();
        }
        catch (Exception e) {
            throw new SlimError(e);
        }
    }

    public static FixtureInteraction getInteraction() {
        return interaction;
    }

    public static class Options {
        final boolean verbose;
        final int port;
        final FixtureInteraction interaction;
        final boolean daemon;
        final Integer statementTimeout;
        final boolean useSSL;
        final String sslParameterClassName;

        public Options(boolean verbose, int port, FixtureInteraction interaction, boolean daemon, Integer statementTimeout, boolean useSSL, String sslParameterClassName) {
            this.verbose = verbose;
            this.port = port;
            this.interaction = interaction;
            this.daemon = daemon;
            this.statementTimeout = statementTimeout;
            this.useSSL = useSSL;
            this.sslParameterClassName = sslParameterClassName;
        }
    }
}

