/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wiki.PathParser;
import fitnesse.wikitext.parser.Collapsible;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import fitnesse.wikitext.parser.WikiWord;

public class Include
extends SymbolType
implements Rule,
Translation {
    private static final String[] setUpSymbols = new String[]{"COLLAPSE_SETUP"};
    private static final String includeHelpOption = "-h";

    public Include() {
        super("Include");
        this.wikiMatcher(new Matcher().startLineOrCell().string("!include"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        Symbol next = parser.moveNext(1);
        if (!next.isType(SymbolType.Whitespace)) {
            return Symbol.nothing;
        }
        next = parser.moveNext(1);
        String option = "";
        if (next.isType(SymbolType.Text) && next.getContent().startsWith("-") || next.isType(SymbolType.DateFormatOption)) {
            option = next.getContent() + (next.isType(SymbolType.DateFormatOption) ? parser.moveNext(1).getContent() : "");
            next = parser.moveNext(1);
            if (!next.isType(SymbolType.Whitespace)) {
                return Symbol.nothing;
            }
            next = parser.moveNext(1);
        }
        current.add(option);
        if (!next.isType(SymbolType.Text) && !next.isType(WikiWord.symbolType)) {
            return Symbol.nothing;
        }
        String includedPageName = next.getContent();
        while (parser.peek().isType(SymbolType.Text) || parser.peek().isType(WikiWord.symbolType)) {
            Symbol remainderOfPageName = parser.moveNext(1);
            includedPageName = includedPageName + remainderOfPageName.getContent();
        }
        SourcePage sourcePage = parser.getPage().getNamedPage();
        if (PathParser.isWikiPath(includedPageName)) {
            current.add(new Symbol(new WikiWord(sourcePage), includedPageName));
        } else {
            current.add(includedPageName);
        }
        Maybe<SourcePage> includedPage = sourcePage.findIncludedPage(includedPageName);
        if (includedPage.isNothing()) {
            current.add("").add(new Symbol(SymbolType.Style, "error").add(includedPage.because()));
        } else if (includeHelpOption.equals(option)) {
            String helpText = includedPage.getValue().getProperty("Help");
            current.add("").add(Parser.make(parser.getPage(), helpText).parse());
        } else {
            current.childAt(1).putProperty("WITH_EDIT", "true");
            ParsingPage included = option.equals("-setup") || option.equals("-teardown") ? parser.getPage() : parser.getPage().copyForNamedPage(includedPage.getValue());
            current.add("").add(Parser.make(included, includedPage.getValue().getContent()).parse());
            if (option.equals("-setup")) {
                current.evaluateVariables(setUpSymbols, parser.getVariableSource());
            }
        }
        if (parser.peek().isType(SymbolType.Newline)) {
            parser.moveNext(1);
        }
        return new Maybe<Symbol>(current);
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        if (symbol.getChildren().size() < 4) {
            return translator.translate(symbol.childAt(2));
        }
        String option = symbol.childAt(0).getContent();
        if (option.equals("-seamless")) {
            return translator.translate(symbol.childAt(3));
        }
        if (includeHelpOption.equals(option)) {
            return translator.translate(symbol.childAt(3));
        }
        String collapseState = this.stateForOption(option, symbol);
        String title = "Included page: " + translator.translate(symbol.childAt(1));
        return Collapsible.generateHtml(collapseState, title, translator.translate(symbol.childAt(3)));
    }

    private String stateForOption(String option, Symbol symbol) {
        return (option.equals("-setup") || option.equals("-teardown")) && symbol.getVariable("COLLAPSE_SETUP", "true").equals("true") || option.equals("-c") ? " closed" : "";
    }
}

